package zio.aws.iot.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  ConsecutiveDatapointsToClear,
  ConsecutiveDatapointsToAlarm,
  DurationSeconds
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class BehaviorCriteria(
    comparisonOperator: Optional[zio.aws.iot.model.ComparisonOperator] =
      Optional.Absent,
    value: Optional[zio.aws.iot.model.MetricValue] = Optional.Absent,
    durationSeconds: Optional[DurationSeconds] = Optional.Absent,
    consecutiveDatapointsToAlarm: Optional[ConsecutiveDatapointsToAlarm] =
      Optional.Absent,
    consecutiveDatapointsToClear: Optional[ConsecutiveDatapointsToClear] =
      Optional.Absent,
    statisticalThreshold: Optional[zio.aws.iot.model.StatisticalThreshold] =
      Optional.Absent,
    mlDetectionConfig: Optional[
      zio.aws.iot.model.MachineLearningDetectionConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.BehaviorCriteria = {
    import BehaviorCriteria.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.BehaviorCriteria
      .builder()
      .optionallyWith(comparisonOperator.map(value => value.unwrap))(
        _.comparisonOperator
      )
      .optionallyWith(value.map(value => value.buildAwsValue()))(_.value)
      .optionallyWith(
        durationSeconds.map(value => DurationSeconds.unwrap(value): Integer)
      )(_.durationSeconds)
      .optionallyWith(
        consecutiveDatapointsToAlarm.map(value =>
          ConsecutiveDatapointsToAlarm.unwrap(value): Integer
        )
      )(_.consecutiveDatapointsToAlarm)
      .optionallyWith(
        consecutiveDatapointsToClear.map(value =>
          ConsecutiveDatapointsToClear.unwrap(value): Integer
        )
      )(_.consecutiveDatapointsToClear)
      .optionallyWith(statisticalThreshold.map(value => value.buildAwsValue()))(
        _.statisticalThreshold
      )
      .optionallyWith(mlDetectionConfig.map(value => value.buildAwsValue()))(
        _.mlDetectionConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.BehaviorCriteria.ReadOnly =
    zio.aws.iot.model.BehaviorCriteria.wrap(buildAwsValue())
}
object BehaviorCriteria {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.BehaviorCriteria
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.BehaviorCriteria =
      zio.aws.iot.model.BehaviorCriteria(
        comparisonOperator.map(value => value),
        value.map(value => value.asEditable),
        durationSeconds.map(value => value),
        consecutiveDatapointsToAlarm.map(value => value),
        consecutiveDatapointsToClear.map(value => value),
        statisticalThreshold.map(value => value.asEditable),
        mlDetectionConfig.map(value => value.asEditable)
      )
    def comparisonOperator: Optional[zio.aws.iot.model.ComparisonOperator]
    def value: Optional[zio.aws.iot.model.MetricValue.ReadOnly]
    def durationSeconds: Optional[DurationSeconds]
    def consecutiveDatapointsToAlarm: Optional[ConsecutiveDatapointsToAlarm]
    def consecutiveDatapointsToClear: Optional[ConsecutiveDatapointsToClear]
    def statisticalThreshold
        : Optional[zio.aws.iot.model.StatisticalThreshold.ReadOnly]
    def mlDetectionConfig
        : Optional[zio.aws.iot.model.MachineLearningDetectionConfig.ReadOnly]
    def getComparisonOperator
        : ZIO[Any, AwsError, zio.aws.iot.model.ComparisonOperator] =
      AwsError.unwrapOptionField("comparisonOperator", comparisonOperator)
    def getValue: ZIO[Any, AwsError, zio.aws.iot.model.MetricValue.ReadOnly] =
      AwsError.unwrapOptionField("value", value)
    def getDurationSeconds: ZIO[Any, AwsError, DurationSeconds] =
      AwsError.unwrapOptionField("durationSeconds", durationSeconds)
    def getConsecutiveDatapointsToAlarm
        : ZIO[Any, AwsError, ConsecutiveDatapointsToAlarm] =
      AwsError.unwrapOptionField(
        "consecutiveDatapointsToAlarm",
        consecutiveDatapointsToAlarm
      )
    def getConsecutiveDatapointsToClear
        : ZIO[Any, AwsError, ConsecutiveDatapointsToClear] =
      AwsError.unwrapOptionField(
        "consecutiveDatapointsToClear",
        consecutiveDatapointsToClear
      )
    def getStatisticalThreshold
        : ZIO[Any, AwsError, zio.aws.iot.model.StatisticalThreshold.ReadOnly] =
      AwsError.unwrapOptionField("statisticalThreshold", statisticalThreshold)
    def getMlDetectionConfig: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.MachineLearningDetectionConfig.ReadOnly
    ] = AwsError.unwrapOptionField("mlDetectionConfig", mlDetectionConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.BehaviorCriteria
  ) extends zio.aws.iot.model.BehaviorCriteria.ReadOnly {
    override val comparisonOperator
        : Optional[zio.aws.iot.model.ComparisonOperator] = zio.aws.core.internal
      .optionalFromNullable(impl.comparisonOperator())
      .map(value => zio.aws.iot.model.ComparisonOperator.wrap(value))
    override val value: Optional[zio.aws.iot.model.MetricValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.value())
        .map(value => zio.aws.iot.model.MetricValue.wrap(value))
    override val durationSeconds: Optional[DurationSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.durationSeconds())
        .map(value => zio.aws.iot.model.primitives.DurationSeconds(value))
    override val consecutiveDatapointsToAlarm
        : Optional[ConsecutiveDatapointsToAlarm] = zio.aws.core.internal
      .optionalFromNullable(impl.consecutiveDatapointsToAlarm())
      .map(value =>
        zio.aws.iot.model.primitives.ConsecutiveDatapointsToAlarm(value)
      )
    override val consecutiveDatapointsToClear
        : Optional[ConsecutiveDatapointsToClear] = zio.aws.core.internal
      .optionalFromNullable(impl.consecutiveDatapointsToClear())
      .map(value =>
        zio.aws.iot.model.primitives.ConsecutiveDatapointsToClear(value)
      )
    override val statisticalThreshold
        : Optional[zio.aws.iot.model.StatisticalThreshold.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statisticalThreshold())
        .map(value => zio.aws.iot.model.StatisticalThreshold.wrap(value))
    override val mlDetectionConfig
        : Optional[zio.aws.iot.model.MachineLearningDetectionConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mlDetectionConfig())
        .map(value =>
          zio.aws.iot.model.MachineLearningDetectionConfig.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.BehaviorCriteria
  ): zio.aws.iot.model.BehaviorCriteria.ReadOnly = new Wrapper(impl)
}
