package zio.aws.iot.model
import scala.jdk.CollectionConverters._
sealed trait BehaviorCriteriaType {
  def unwrap: software.amazon.awssdk.services.iot.model.BehaviorCriteriaType
}
object BehaviorCriteriaType {
  def wrap(
      value: software.amazon.awssdk.services.iot.model.BehaviorCriteriaType
  ): zio.aws.iot.model.BehaviorCriteriaType = value match {
    case software.amazon.awssdk.services.iot.model.BehaviorCriteriaType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iot.model.BehaviorCriteriaType.STATIC =>
      val r = STATIC
      r
    case software.amazon.awssdk.services.iot.model.BehaviorCriteriaType.STATISTICAL =>
      val r = STATISTICAL
      r
    case software.amazon.awssdk.services.iot.model.BehaviorCriteriaType.MACHINE_LEARNING =>
      val r = MACHINE_LEARNING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iot.model.BehaviorCriteriaType {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.BehaviorCriteriaType =
      software.amazon.awssdk.services.iot.model.BehaviorCriteriaType.UNKNOWN_TO_SDK_VERSION
  }
  case object STATIC extends zio.aws.iot.model.BehaviorCriteriaType {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.BehaviorCriteriaType =
      software.amazon.awssdk.services.iot.model.BehaviorCriteriaType.STATIC
  }
  case object STATISTICAL extends zio.aws.iot.model.BehaviorCriteriaType {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.BehaviorCriteriaType =
      software.amazon.awssdk.services.iot.model.BehaviorCriteriaType.STATISTICAL
  }
  case object MACHINE_LEARNING extends zio.aws.iot.model.BehaviorCriteriaType {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.BehaviorCriteriaType =
      software.amazon.awssdk.services.iot.model.BehaviorCriteriaType.MACHINE_LEARNING
  }
}
