package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.BillingGroupDescription
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BillingGroupProperties(
    billingGroupDescription: Optional[BillingGroupDescription] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.BillingGroupProperties = {
    import BillingGroupProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.BillingGroupProperties
      .builder()
      .optionallyWith(
        billingGroupDescription.map(value =>
          BillingGroupDescription.unwrap(value): java.lang.String
        )
      )(_.billingGroupDescription)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.BillingGroupProperties.ReadOnly =
    zio.aws.iot.model.BillingGroupProperties.wrap(buildAwsValue())
}
object BillingGroupProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.BillingGroupProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.BillingGroupProperties = zio.aws.iot.model
      .BillingGroupProperties(billingGroupDescription.map(value => value))
    def billingGroupDescription: Optional[BillingGroupDescription]
    def getBillingGroupDescription
        : ZIO[Any, AwsError, BillingGroupDescription] = AwsError
      .unwrapOptionField("billingGroupDescription", billingGroupDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.BillingGroupProperties
  ) extends zio.aws.iot.model.BillingGroupProperties.ReadOnly {
    override val billingGroupDescription: Optional[BillingGroupDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.billingGroupDescription())
        .map(value =>
          zio.aws.iot.model.primitives.BillingGroupDescription(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.BillingGroupProperties
  ): zio.aws.iot.model.BillingGroupProperties.ReadOnly = new Wrapper(impl)
}
