package zio.aws.iot.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{Count, BucketKeyValue}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class Bucket(
    keyValue: Optional[BucketKeyValue] = Optional.Absent,
    count: Optional[Count] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.iot.model.Bucket = {
    import Bucket.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.Bucket
      .builder()
      .optionallyWith(
        keyValue.map(value => BucketKeyValue.unwrap(value): java.lang.String)
      )(_.keyValue)
      .optionallyWith(count.map(value => Count.unwrap(value): Integer))(_.count)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.Bucket.ReadOnly =
    zio.aws.iot.model.Bucket.wrap(buildAwsValue())
}
object Bucket {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.Bucket] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.Bucket = zio.aws.iot.model
      .Bucket(keyValue.map(value => value), count.map(value => value))
    def keyValue: Optional[BucketKeyValue]
    def count: Optional[Count]
    def getKeyValue: ZIO[Any, AwsError, BucketKeyValue] =
      AwsError.unwrapOptionField("keyValue", keyValue)
    def getCount: ZIO[Any, AwsError, Count] =
      AwsError.unwrapOptionField("count", count)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.Bucket
  ) extends zio.aws.iot.model.Bucket.ReadOnly {
    override val keyValue: Optional[BucketKeyValue] = zio.aws.core.internal
      .optionalFromNullable(impl.keyValue())
      .map(value => zio.aws.iot.model.primitives.BucketKeyValue(value))
    override val count: Optional[Count] = zio.aws.core.internal
      .optionalFromNullable(impl.count())
      .map(value => zio.aws.iot.model.primitives.Count(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.Bucket
  ): zio.aws.iot.model.Bucket.ReadOnly = new Wrapper(impl)
}
