package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.AuditTaskId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CancelAuditTaskRequest(taskId: AuditTaskId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CancelAuditTaskRequest = {
    import CancelAuditTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CancelAuditTaskRequest
      .builder()
      .taskId(AuditTaskId.unwrap(taskId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CancelAuditTaskRequest.ReadOnly =
    zio.aws.iot.model.CancelAuditTaskRequest.wrap(buildAwsValue())
}
object CancelAuditTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CancelAuditTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CancelAuditTaskRequest =
      zio.aws.iot.model.CancelAuditTaskRequest(taskId)
    def taskId: AuditTaskId
    def getTaskId: ZIO[Any, Nothing, AuditTaskId] = ZIO.succeed(taskId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CancelAuditTaskRequest
  ) extends zio.aws.iot.model.CancelAuditTaskRequest.ReadOnly {
    override val taskId: AuditTaskId =
      zio.aws.iot.model.primitives.AuditTaskId(impl.taskId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CancelAuditTaskRequest
  ): zio.aws.iot.model.CancelAuditTaskRequest.ReadOnly = new Wrapper(impl)
}
