package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.CertificateId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CancelCertificateTransferRequest(
    certificateId: CertificateId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CancelCertificateTransferRequest = {
    import CancelCertificateTransferRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CancelCertificateTransferRequest
      .builder()
      .certificateId(CertificateId.unwrap(certificateId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CancelCertificateTransferRequest.ReadOnly =
    zio.aws.iot.model.CancelCertificateTransferRequest.wrap(buildAwsValue())
}
object CancelCertificateTransferRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CancelCertificateTransferRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CancelCertificateTransferRequest =
      zio.aws.iot.model.CancelCertificateTransferRequest(certificateId)
    def certificateId: CertificateId
    def getCertificateId: ZIO[Any, Nothing, CertificateId] =
      ZIO.succeed(certificateId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CancelCertificateTransferRequest
  ) extends zio.aws.iot.model.CancelCertificateTransferRequest.ReadOnly {
    override val certificateId: CertificateId =
      zio.aws.iot.model.primitives.CertificateId(impl.certificateId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CancelCertificateTransferRequest
  ): zio.aws.iot.model.CancelCertificateTransferRequest.ReadOnly = new Wrapper(
    impl
  )
}
