package zio.aws.iot.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  DateType,
  CertificateId,
  CertificateArn,
  CertificatePem,
  CustomerVersion,
  AwsAccountId,
  GenerationId
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CertificateDescription(
    certificateArn: Optional[CertificateArn] = Optional.Absent,
    certificateId: Optional[CertificateId] = Optional.Absent,
    caCertificateId: Optional[CertificateId] = Optional.Absent,
    status: Optional[zio.aws.iot.model.CertificateStatus] = Optional.Absent,
    certificatePem: Optional[CertificatePem] = Optional.Absent,
    ownedBy: Optional[AwsAccountId] = Optional.Absent,
    previousOwnedBy: Optional[AwsAccountId] = Optional.Absent,
    creationDate: Optional[DateType] = Optional.Absent,
    lastModifiedDate: Optional[DateType] = Optional.Absent,
    customerVersion: Optional[CustomerVersion] = Optional.Absent,
    transferData: Optional[zio.aws.iot.model.TransferData] = Optional.Absent,
    generationId: Optional[GenerationId] = Optional.Absent,
    validity: Optional[zio.aws.iot.model.CertificateValidity] = Optional.Absent,
    certificateMode: Optional[zio.aws.iot.model.CertificateMode] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CertificateDescription = {
    import CertificateDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CertificateDescription
      .builder()
      .optionallyWith(
        certificateArn.map(value =>
          CertificateArn.unwrap(value): java.lang.String
        )
      )(_.certificateArn)
      .optionallyWith(
        certificateId.map(value =>
          CertificateId.unwrap(value): java.lang.String
        )
      )(_.certificateId)
      .optionallyWith(
        caCertificateId.map(value =>
          CertificateId.unwrap(value): java.lang.String
        )
      )(_.caCertificateId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        certificatePem.map(value =>
          CertificatePem.unwrap(value): java.lang.String
        )
      )(_.certificatePem)
      .optionallyWith(
        ownedBy.map(value => AwsAccountId.unwrap(value): java.lang.String)
      )(_.ownedBy)
      .optionallyWith(
        previousOwnedBy.map(value =>
          AwsAccountId.unwrap(value): java.lang.String
        )
      )(_.previousOwnedBy)
      .optionallyWith(
        creationDate.map(value => DateType.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        lastModifiedDate.map(value => DateType.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .optionallyWith(
        customerVersion.map(value => CustomerVersion.unwrap(value): Integer)
      )(_.customerVersion)
      .optionallyWith(transferData.map(value => value.buildAwsValue()))(
        _.transferData
      )
      .optionallyWith(
        generationId.map(value => GenerationId.unwrap(value): java.lang.String)
      )(_.generationId)
      .optionallyWith(validity.map(value => value.buildAwsValue()))(_.validity)
      .optionallyWith(certificateMode.map(value => value.unwrap))(
        _.certificateMode
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CertificateDescription.ReadOnly =
    zio.aws.iot.model.CertificateDescription.wrap(buildAwsValue())
}
object CertificateDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CertificateDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CertificateDescription =
      zio.aws.iot.model.CertificateDescription(
        certificateArn.map(value => value),
        certificateId.map(value => value),
        caCertificateId.map(value => value),
        status.map(value => value),
        certificatePem.map(value => value),
        ownedBy.map(value => value),
        previousOwnedBy.map(value => value),
        creationDate.map(value => value),
        lastModifiedDate.map(value => value),
        customerVersion.map(value => value),
        transferData.map(value => value.asEditable),
        generationId.map(value => value),
        validity.map(value => value.asEditable),
        certificateMode.map(value => value)
      )
    def certificateArn: Optional[CertificateArn]
    def certificateId: Optional[CertificateId]
    def caCertificateId: Optional[CertificateId]
    def status: Optional[zio.aws.iot.model.CertificateStatus]
    def certificatePem: Optional[CertificatePem]
    def ownedBy: Optional[AwsAccountId]
    def previousOwnedBy: Optional[AwsAccountId]
    def creationDate: Optional[DateType]
    def lastModifiedDate: Optional[DateType]
    def customerVersion: Optional[CustomerVersion]
    def transferData: Optional[zio.aws.iot.model.TransferData.ReadOnly]
    def generationId: Optional[GenerationId]
    def validity: Optional[zio.aws.iot.model.CertificateValidity.ReadOnly]
    def certificateMode: Optional[zio.aws.iot.model.CertificateMode]
    def getCertificateArn: ZIO[Any, AwsError, CertificateArn] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
    def getCertificateId: ZIO[Any, AwsError, CertificateId] =
      AwsError.unwrapOptionField("certificateId", certificateId)
    def getCaCertificateId: ZIO[Any, AwsError, CertificateId] =
      AwsError.unwrapOptionField("caCertificateId", caCertificateId)
    def getStatus: ZIO[Any, AwsError, zio.aws.iot.model.CertificateStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCertificatePem: ZIO[Any, AwsError, CertificatePem] =
      AwsError.unwrapOptionField("certificatePem", certificatePem)
    def getOwnedBy: ZIO[Any, AwsError, AwsAccountId] =
      AwsError.unwrapOptionField("ownedBy", ownedBy)
    def getPreviousOwnedBy: ZIO[Any, AwsError, AwsAccountId] =
      AwsError.unwrapOptionField("previousOwnedBy", previousOwnedBy)
    def getCreationDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getLastModifiedDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getCustomerVersion: ZIO[Any, AwsError, CustomerVersion] =
      AwsError.unwrapOptionField("customerVersion", customerVersion)
    def getTransferData
        : ZIO[Any, AwsError, zio.aws.iot.model.TransferData.ReadOnly] =
      AwsError.unwrapOptionField("transferData", transferData)
    def getGenerationId: ZIO[Any, AwsError, GenerationId] =
      AwsError.unwrapOptionField("generationId", generationId)
    def getValidity
        : ZIO[Any, AwsError, zio.aws.iot.model.CertificateValidity.ReadOnly] =
      AwsError.unwrapOptionField("validity", validity)
    def getCertificateMode
        : ZIO[Any, AwsError, zio.aws.iot.model.CertificateMode] =
      AwsError.unwrapOptionField("certificateMode", certificateMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CertificateDescription
  ) extends zio.aws.iot.model.CertificateDescription.ReadOnly {
    override val certificateArn: Optional[CertificateArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateArn())
        .map(value => zio.aws.iot.model.primitives.CertificateArn(value))
    override val certificateId: Optional[CertificateId] = zio.aws.core.internal
      .optionalFromNullable(impl.certificateId())
      .map(value => zio.aws.iot.model.primitives.CertificateId(value))
    override val caCertificateId: Optional[CertificateId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.caCertificateId())
        .map(value => zio.aws.iot.model.primitives.CertificateId(value))
    override val status: Optional[zio.aws.iot.model.CertificateStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.iot.model.CertificateStatus.wrap(value))
    override val certificatePem: Optional[CertificatePem] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificatePem())
        .map(value => zio.aws.iot.model.primitives.CertificatePem(value))
    override val ownedBy: Optional[AwsAccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.ownedBy())
      .map(value => zio.aws.iot.model.primitives.AwsAccountId(value))
    override val previousOwnedBy: Optional[AwsAccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.previousOwnedBy())
      .map(value => zio.aws.iot.model.primitives.AwsAccountId(value))
    override val creationDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val lastModifiedDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedDate())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val customerVersion: Optional[CustomerVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customerVersion())
        .map(value => zio.aws.iot.model.primitives.CustomerVersion(value))
    override val transferData
        : Optional[zio.aws.iot.model.TransferData.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transferData())
        .map(value => zio.aws.iot.model.TransferData.wrap(value))
    override val generationId: Optional[GenerationId] = zio.aws.core.internal
      .optionalFromNullable(impl.generationId())
      .map(value => zio.aws.iot.model.primitives.GenerationId(value))
    override val validity
        : Optional[zio.aws.iot.model.CertificateValidity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.validity())
        .map(value => zio.aws.iot.model.CertificateValidity.wrap(value))
    override val certificateMode: Optional[zio.aws.iot.model.CertificateMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateMode())
        .map(value => zio.aws.iot.model.CertificateMode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CertificateDescription
  ): zio.aws.iot.model.CertificateDescription.ReadOnly = new Wrapper(impl)
}
