package zio.aws.iot.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.DateType
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class CertificateValidity(
    notBefore: Optional[DateType] = Optional.Absent,
    notAfter: Optional[DateType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CertificateValidity = {
    import CertificateValidity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CertificateValidity
      .builder()
      .optionallyWith(notBefore.map(value => DateType.unwrap(value): Instant))(
        _.notBefore
      )
      .optionallyWith(notAfter.map(value => DateType.unwrap(value): Instant))(
        _.notAfter
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CertificateValidity.ReadOnly =
    zio.aws.iot.model.CertificateValidity.wrap(buildAwsValue())
}
object CertificateValidity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CertificateValidity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CertificateValidity =
      zio.aws.iot.model.CertificateValidity(
        notBefore.map(value => value),
        notAfter.map(value => value)
      )
    def notBefore: Optional[DateType]
    def notAfter: Optional[DateType]
    def getNotBefore: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("notBefore", notBefore)
    def getNotAfter: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("notAfter", notAfter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CertificateValidity
  ) extends zio.aws.iot.model.CertificateValidity.ReadOnly {
    override val notBefore: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.notBefore())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val notAfter: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.notAfter())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CertificateValidity
  ): zio.aws.iot.model.CertificateValidity.ReadOnly = new Wrapper(impl)
}
