package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{StateValue, StateReason, AlarmName, AwsArn}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CloudwatchAlarmAction(
    roleArn: AwsArn,
    alarmName: AlarmName,
    stateReason: StateReason,
    stateValue: StateValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CloudwatchAlarmAction = {
    import CloudwatchAlarmAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CloudwatchAlarmAction
      .builder()
      .roleArn(AwsArn.unwrap(roleArn): java.lang.String)
      .alarmName(AlarmName.unwrap(alarmName): java.lang.String)
      .stateReason(StateReason.unwrap(stateReason): java.lang.String)
      .stateValue(StateValue.unwrap(stateValue): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CloudwatchAlarmAction.ReadOnly =
    zio.aws.iot.model.CloudwatchAlarmAction.wrap(buildAwsValue())
}
object CloudwatchAlarmAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CloudwatchAlarmAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CloudwatchAlarmAction = zio.aws.iot.model
      .CloudwatchAlarmAction(roleArn, alarmName, stateReason, stateValue)
    def roleArn: AwsArn
    def alarmName: AlarmName
    def stateReason: StateReason
    def stateValue: StateValue
    def getRoleArn: ZIO[Any, Nothing, AwsArn] = ZIO.succeed(roleArn)
    def getAlarmName: ZIO[Any, Nothing, AlarmName] = ZIO.succeed(alarmName)
    def getStateReason: ZIO[Any, Nothing, StateReason] =
      ZIO.succeed(stateReason)
    def getStateValue: ZIO[Any, Nothing, StateValue] = ZIO.succeed(stateValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CloudwatchAlarmAction
  ) extends zio.aws.iot.model.CloudwatchAlarmAction.ReadOnly {
    override val roleArn: AwsArn =
      zio.aws.iot.model.primitives.AwsArn(impl.roleArn())
    override val alarmName: AlarmName =
      zio.aws.iot.model.primitives.AlarmName(impl.alarmName())
    override val stateReason: StateReason =
      zio.aws.iot.model.primitives.StateReason(impl.stateReason())
    override val stateValue: StateValue =
      zio.aws.iot.model.primitives.StateValue(impl.stateValue())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CloudwatchAlarmAction
  ): zio.aws.iot.model.CloudwatchAlarmAction.ReadOnly = new Wrapper(impl)
}
