package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.AwsArn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CloudwatchMetricAction(
    roleArn: AwsArn,
    metricNamespace: String,
    metricName: String,
    metricValue: String,
    metricUnit: String,
    metricTimestamp: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CloudwatchMetricAction = {
    import CloudwatchMetricAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CloudwatchMetricAction
      .builder()
      .roleArn(AwsArn.unwrap(roleArn): java.lang.String)
      .metricNamespace(metricNamespace: java.lang.String)
      .metricName(metricName: java.lang.String)
      .metricValue(metricValue: java.lang.String)
      .metricUnit(metricUnit: java.lang.String)
      .optionallyWith(metricTimestamp.map(value => value: java.lang.String))(
        _.metricTimestamp
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CloudwatchMetricAction.ReadOnly =
    zio.aws.iot.model.CloudwatchMetricAction.wrap(buildAwsValue())
}
object CloudwatchMetricAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CloudwatchMetricAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CloudwatchMetricAction =
      zio.aws.iot.model.CloudwatchMetricAction(
        roleArn,
        metricNamespace,
        metricName,
        metricValue,
        metricUnit,
        metricTimestamp.map(value => value)
      )
    def roleArn: AwsArn
    def metricNamespace: String
    def metricName: String
    def metricValue: String
    def metricUnit: String
    def metricTimestamp: Optional[String]
    def getRoleArn: ZIO[Any, Nothing, AwsArn] = ZIO.succeed(roleArn)
    def getMetricNamespace: ZIO[Any, Nothing, String] =
      ZIO.succeed(metricNamespace)
    def getMetricName: ZIO[Any, Nothing, String] = ZIO.succeed(metricName)
    def getMetricValue: ZIO[Any, Nothing, String] = ZIO.succeed(metricValue)
    def getMetricUnit: ZIO[Any, Nothing, String] = ZIO.succeed(metricUnit)
    def getMetricTimestamp: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("metricTimestamp", metricTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CloudwatchMetricAction
  ) extends zio.aws.iot.model.CloudwatchMetricAction.ReadOnly {
    override val roleArn: AwsArn =
      zio.aws.iot.model.primitives.AwsArn(impl.roleArn())
    override val metricNamespace: String = impl.metricNamespace(): String
    override val metricName: String = impl.metricName(): String
    override val metricValue: String = impl.metricValue(): String
    override val metricUnit: String = impl.metricUnit(): String
    override val metricTimestamp: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.metricTimestamp())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CloudwatchMetricAction
  ): zio.aws.iot.model.CloudwatchMetricAction.ReadOnly = new Wrapper(impl)
}
