package zio.aws.iot.model
import scala.jdk.CollectionConverters._
sealed trait ComparisonOperator {
  def unwrap: software.amazon.awssdk.services.iot.model.ComparisonOperator
}
object ComparisonOperator {
  def wrap(
      value: software.amazon.awssdk.services.iot.model.ComparisonOperator
  ): zio.aws.iot.model.ComparisonOperator = value match {
    case software.amazon.awssdk.services.iot.model.ComparisonOperator.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iot.model.ComparisonOperator.LESS_THAN =>
      val r = `less-than`
      r
    case software.amazon.awssdk.services.iot.model.ComparisonOperator.LESS_THAN_EQUALS =>
      val r = `less-than-equals`
      r
    case software.amazon.awssdk.services.iot.model.ComparisonOperator.GREATER_THAN =>
      val r = `greater-than`
      r
    case software.amazon.awssdk.services.iot.model.ComparisonOperator.GREATER_THAN_EQUALS =>
      val r = `greater-than-equals`
      r
    case software.amazon.awssdk.services.iot.model.ComparisonOperator.IN_CIDR_SET =>
      val r = `in-cidr-set`
      r
    case software.amazon.awssdk.services.iot.model.ComparisonOperator.NOT_IN_CIDR_SET =>
      val r = `not-in-cidr-set`
      r
    case software.amazon.awssdk.services.iot.model.ComparisonOperator.IN_PORT_SET =>
      val r = `in-port-set`
      r
    case software.amazon.awssdk.services.iot.model.ComparisonOperator.NOT_IN_PORT_SET =>
      val r = `not-in-port-set`
      r
    case software.amazon.awssdk.services.iot.model.ComparisonOperator.IN_SET =>
      val r = `in-set`
      r
    case software.amazon.awssdk.services.iot.model.ComparisonOperator.NOT_IN_SET =>
      val r = `not-in-set`
      r
  }
  case object unknownToSdkVersion extends zio.aws.iot.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.ComparisonOperator =
      software.amazon.awssdk.services.iot.model.ComparisonOperator.UNKNOWN_TO_SDK_VERSION
  }
  case object `less-than` extends zio.aws.iot.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.ComparisonOperator =
      software.amazon.awssdk.services.iot.model.ComparisonOperator.LESS_THAN
  }
  case object `less-than-equals` extends zio.aws.iot.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.ComparisonOperator =
      software.amazon.awssdk.services.iot.model.ComparisonOperator.LESS_THAN_EQUALS
  }
  case object `greater-than` extends zio.aws.iot.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.ComparisonOperator =
      software.amazon.awssdk.services.iot.model.ComparisonOperator.GREATER_THAN
  }
  case object `greater-than-equals`
      extends zio.aws.iot.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.ComparisonOperator =
      software.amazon.awssdk.services.iot.model.ComparisonOperator.GREATER_THAN_EQUALS
  }
  case object `in-cidr-set` extends zio.aws.iot.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.ComparisonOperator =
      software.amazon.awssdk.services.iot.model.ComparisonOperator.IN_CIDR_SET
  }
  case object `not-in-cidr-set` extends zio.aws.iot.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.ComparisonOperator =
      software.amazon.awssdk.services.iot.model.ComparisonOperator.NOT_IN_CIDR_SET
  }
  case object `in-port-set` extends zio.aws.iot.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.ComparisonOperator =
      software.amazon.awssdk.services.iot.model.ComparisonOperator.IN_PORT_SET
  }
  case object `not-in-port-set` extends zio.aws.iot.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.ComparisonOperator =
      software.amazon.awssdk.services.iot.model.ComparisonOperator.NOT_IN_PORT_SET
  }
  case object `in-set` extends zio.aws.iot.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.ComparisonOperator =
      software.amazon.awssdk.services.iot.model.ComparisonOperator.IN_SET
  }
  case object `not-in-set` extends zio.aws.iot.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.ComparisonOperator =
      software.amazon.awssdk.services.iot.model.ComparisonOperator.NOT_IN_SET
  }
}
