package zio.aws.iot.model
import scala.jdk.CollectionConverters._
sealed trait ConfidenceLevel {
  def unwrap: software.amazon.awssdk.services.iot.model.ConfidenceLevel
}
object ConfidenceLevel {
  def wrap(
      value: software.amazon.awssdk.services.iot.model.ConfidenceLevel
  ): zio.aws.iot.model.ConfidenceLevel = value match {
    case software.amazon.awssdk.services.iot.model.ConfidenceLevel.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iot.model.ConfidenceLevel.LOW =>
      val r = LOW
      r
    case software.amazon.awssdk.services.iot.model.ConfidenceLevel.MEDIUM =>
      val r = MEDIUM
      r
    case software.amazon.awssdk.services.iot.model.ConfidenceLevel.HIGH =>
      val r = HIGH
      r
  }
  case object unknownToSdkVersion extends zio.aws.iot.model.ConfidenceLevel {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.ConfidenceLevel =
      software.amazon.awssdk.services.iot.model.ConfidenceLevel.UNKNOWN_TO_SDK_VERSION
  }
  case object LOW extends zio.aws.iot.model.ConfidenceLevel {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.ConfidenceLevel =
      software.amazon.awssdk.services.iot.model.ConfidenceLevel.LOW
  }
  case object MEDIUM extends zio.aws.iot.model.ConfidenceLevel {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.ConfidenceLevel =
      software.amazon.awssdk.services.iot.model.ConfidenceLevel.MEDIUM
  }
  case object HIGH extends zio.aws.iot.model.ConfidenceLevel {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.ConfidenceLevel =
      software.amazon.awssdk.services.iot.model.ConfidenceLevel.HIGH
  }
}
