package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.ConfirmationToken
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ConfirmTopicRuleDestinationRequest(
    confirmationToken: ConfirmationToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ConfirmTopicRuleDestinationRequest = {
    import ConfirmTopicRuleDestinationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ConfirmTopicRuleDestinationRequest
      .builder()
      .confirmationToken(
        ConfirmationToken.unwrap(confirmationToken): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.ConfirmTopicRuleDestinationRequest.ReadOnly =
    zio.aws.iot.model.ConfirmTopicRuleDestinationRequest.wrap(buildAwsValue())
}
object ConfirmTopicRuleDestinationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ConfirmTopicRuleDestinationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ConfirmTopicRuleDestinationRequest =
      zio.aws.iot.model.ConfirmTopicRuleDestinationRequest(confirmationToken)
    def confirmationToken: ConfirmationToken
    def getConfirmationToken: ZIO[Any, Nothing, ConfirmationToken] =
      ZIO.succeed(confirmationToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ConfirmTopicRuleDestinationRequest
  ) extends zio.aws.iot.model.ConfirmTopicRuleDestinationRequest.ReadOnly {
    override val confirmationToken: ConfirmationToken =
      zio.aws.iot.model.primitives.ConfirmationToken(impl.confirmationToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ConfirmTopicRuleDestinationRequest
  ): zio.aws.iot.model.ConfirmTopicRuleDestinationRequest.ReadOnly =
    new Wrapper(impl)
}
