package zio.aws.iot.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  SuppressIndefinitely,
  Timestamp,
  ClientRequestToken,
  AuditDescription,
  AuditCheckName
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class CreateAuditSuppressionRequest(
    checkName: AuditCheckName,
    resourceIdentifier: zio.aws.iot.model.ResourceIdentifier,
    expirationDate: Optional[Timestamp] = Optional.Absent,
    suppressIndefinitely: Optional[SuppressIndefinitely] = Optional.Absent,
    description: Optional[AuditDescription] = Optional.Absent,
    clientRequestToken: ClientRequestToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreateAuditSuppressionRequest = {
    import CreateAuditSuppressionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreateAuditSuppressionRequest
      .builder()
      .checkName(AuditCheckName.unwrap(checkName): java.lang.String)
      .resourceIdentifier(resourceIdentifier.buildAwsValue())
      .optionallyWith(
        expirationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.expirationDate)
      .optionallyWith(
        suppressIndefinitely.map(value =>
          SuppressIndefinitely.unwrap(value): java.lang.Boolean
        )
      )(_.suppressIndefinitely)
      .optionallyWith(
        description.map(value =>
          AuditDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .clientRequestToken(
        ClientRequestToken.unwrap(clientRequestToken): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CreateAuditSuppressionRequest.ReadOnly =
    zio.aws.iot.model.CreateAuditSuppressionRequest.wrap(buildAwsValue())
}
object CreateAuditSuppressionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreateAuditSuppressionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreateAuditSuppressionRequest =
      zio.aws.iot.model.CreateAuditSuppressionRequest(
        checkName,
        resourceIdentifier.asEditable,
        expirationDate.map(value => value),
        suppressIndefinitely.map(value => value),
        description.map(value => value),
        clientRequestToken
      )
    def checkName: AuditCheckName
    def resourceIdentifier: zio.aws.iot.model.ResourceIdentifier.ReadOnly
    def expirationDate: Optional[Timestamp]
    def suppressIndefinitely: Optional[SuppressIndefinitely]
    def description: Optional[AuditDescription]
    def clientRequestToken: ClientRequestToken
    def getCheckName: ZIO[Any, Nothing, AuditCheckName] = ZIO.succeed(checkName)
    def getResourceIdentifier
        : ZIO[Any, Nothing, zio.aws.iot.model.ResourceIdentifier.ReadOnly] =
      ZIO.succeed(resourceIdentifier)
    def getExpirationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("expirationDate", expirationDate)
    def getSuppressIndefinitely: ZIO[Any, AwsError, SuppressIndefinitely] =
      AwsError.unwrapOptionField("suppressIndefinitely", suppressIndefinitely)
    def getDescription: ZIO[Any, AwsError, AuditDescription] =
      AwsError.unwrapOptionField("description", description)
    def getClientRequestToken: ZIO[Any, Nothing, ClientRequestToken] =
      ZIO.succeed(clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreateAuditSuppressionRequest
  ) extends zio.aws.iot.model.CreateAuditSuppressionRequest.ReadOnly {
    override val checkName: AuditCheckName =
      zio.aws.iot.model.primitives.AuditCheckName(impl.checkName())
    override val resourceIdentifier
        : zio.aws.iot.model.ResourceIdentifier.ReadOnly =
      zio.aws.iot.model.ResourceIdentifier.wrap(impl.resourceIdentifier())
    override val expirationDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.expirationDate())
      .map(value => zio.aws.iot.model.primitives.Timestamp(value))
    override val suppressIndefinitely: Optional[SuppressIndefinitely] =
      zio.aws.core.internal
        .optionalFromNullable(impl.suppressIndefinitely())
        .map(value => zio.aws.iot.model.primitives.SuppressIndefinitely(value))
    override val description: Optional[AuditDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iot.model.primitives.AuditDescription(value))
    override val clientRequestToken: ClientRequestToken =
      zio.aws.iot.model.primitives.ClientRequestToken(impl.clientRequestToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreateAuditSuppressionRequest
  ): zio.aws.iot.model.CreateAuditSuppressionRequest.ReadOnly = new Wrapper(
    impl
  )
}
