package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  KeyValue,
  BooleanKey,
  EnableCachingForHttp,
  KeyName,
  AuthorizerName,
  AuthorizerFunctionArn,
  TokenKeyName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateAuthorizerRequest(
    authorizerName: AuthorizerName,
    authorizerFunctionArn: AuthorizerFunctionArn,
    tokenKeyName: Optional[TokenKeyName] = Optional.Absent,
    tokenSigningPublicKeys: Optional[Map[KeyName, KeyValue]] = Optional.Absent,
    status: Optional[zio.aws.iot.model.AuthorizerStatus] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.iot.model.Tag]] = Optional.Absent,
    signingDisabled: Optional[BooleanKey] = Optional.Absent,
    enableCachingForHttp: Optional[EnableCachingForHttp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreateAuthorizerRequest = {
    import CreateAuthorizerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreateAuthorizerRequest
      .builder()
      .authorizerName(AuthorizerName.unwrap(authorizerName): java.lang.String)
      .authorizerFunctionArn(
        AuthorizerFunctionArn.unwrap(authorizerFunctionArn): java.lang.String
      )
      .optionallyWith(
        tokenKeyName.map(value => TokenKeyName.unwrap(value): java.lang.String)
      )(_.tokenKeyName)
      .optionallyWith(
        tokenSigningPublicKeys.map(value =>
          value
            .map({ case (key, value) =>
              (KeyName.unwrap(key): java.lang.String) -> (KeyValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tokenSigningPublicKeys)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        signingDisabled.map(value =>
          BooleanKey.unwrap(value): java.lang.Boolean
        )
      )(_.signingDisabled)
      .optionallyWith(
        enableCachingForHttp.map(value =>
          EnableCachingForHttp.unwrap(value): java.lang.Boolean
        )
      )(_.enableCachingForHttp)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CreateAuthorizerRequest.ReadOnly =
    zio.aws.iot.model.CreateAuthorizerRequest.wrap(buildAwsValue())
}
object CreateAuthorizerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreateAuthorizerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreateAuthorizerRequest =
      zio.aws.iot.model.CreateAuthorizerRequest(
        authorizerName,
        authorizerFunctionArn,
        tokenKeyName.map(value => value),
        tokenSigningPublicKeys.map(value => value),
        status.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        signingDisabled.map(value => value),
        enableCachingForHttp.map(value => value)
      )
    def authorizerName: AuthorizerName
    def authorizerFunctionArn: AuthorizerFunctionArn
    def tokenKeyName: Optional[TokenKeyName]
    def tokenSigningPublicKeys: Optional[Map[KeyName, KeyValue]]
    def status: Optional[zio.aws.iot.model.AuthorizerStatus]
    def tags: Optional[List[zio.aws.iot.model.Tag.ReadOnly]]
    def signingDisabled: Optional[BooleanKey]
    def enableCachingForHttp: Optional[EnableCachingForHttp]
    def getAuthorizerName: ZIO[Any, Nothing, AuthorizerName] =
      ZIO.succeed(authorizerName)
    def getAuthorizerFunctionArn: ZIO[Any, Nothing, AuthorizerFunctionArn] =
      ZIO.succeed(authorizerFunctionArn)
    def getTokenKeyName: ZIO[Any, AwsError, TokenKeyName] =
      AwsError.unwrapOptionField("tokenKeyName", tokenKeyName)
    def getTokenSigningPublicKeys: ZIO[Any, AwsError, Map[KeyName, KeyValue]] =
      AwsError.unwrapOptionField(
        "tokenSigningPublicKeys",
        tokenSigningPublicKeys
      )
    def getStatus: ZIO[Any, AwsError, zio.aws.iot.model.AuthorizerStatus] =
      AwsError.unwrapOptionField("status", status)
    def getTags: ZIO[Any, AwsError, List[zio.aws.iot.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getSigningDisabled: ZIO[Any, AwsError, BooleanKey] =
      AwsError.unwrapOptionField("signingDisabled", signingDisabled)
    def getEnableCachingForHttp: ZIO[Any, AwsError, EnableCachingForHttp] =
      AwsError.unwrapOptionField("enableCachingForHttp", enableCachingForHttp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreateAuthorizerRequest
  ) extends zio.aws.iot.model.CreateAuthorizerRequest.ReadOnly {
    override val authorizerName: AuthorizerName =
      zio.aws.iot.model.primitives.AuthorizerName(impl.authorizerName())
    override val authorizerFunctionArn: AuthorizerFunctionArn =
      zio.aws.iot.model.primitives
        .AuthorizerFunctionArn(impl.authorizerFunctionArn())
    override val tokenKeyName: Optional[TokenKeyName] = zio.aws.core.internal
      .optionalFromNullable(impl.tokenKeyName())
      .map(value => zio.aws.iot.model.primitives.TokenKeyName(value))
    override val tokenSigningPublicKeys: Optional[Map[KeyName, KeyValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tokenSigningPublicKeys())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.iot.model.primitives
                .KeyName(key) -> zio.aws.iot.model.primitives.KeyValue(value)
            })
            .toMap
        )
    override val status: Optional[zio.aws.iot.model.AuthorizerStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.iot.model.AuthorizerStatus.wrap(value))
    override val tags: Optional[List[zio.aws.iot.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.Tag.wrap(item)
          }.toList
        )
    override val signingDisabled: Optional[BooleanKey] = zio.aws.core.internal
      .optionalFromNullable(impl.signingDisabled())
      .map(value => zio.aws.iot.model.primitives.BooleanKey(value))
    override val enableCachingForHttp: Optional[EnableCachingForHttp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableCachingForHttp())
        .map(value => zio.aws.iot.model.primitives.EnableCachingForHttp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreateAuthorizerRequest
  ): zio.aws.iot.model.CreateAuthorizerRequest.ReadOnly = new Wrapper(impl)
}
