package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{AuthorizerArn, AuthorizerName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateAuthorizerResponse(
    authorizerName: Optional[AuthorizerName] = Optional.Absent,
    authorizerArn: Optional[AuthorizerArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreateAuthorizerResponse = {
    import CreateAuthorizerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreateAuthorizerResponse
      .builder()
      .optionallyWith(
        authorizerName.map(value =>
          AuthorizerName.unwrap(value): java.lang.String
        )
      )(_.authorizerName)
      .optionallyWith(
        authorizerArn.map(value =>
          AuthorizerArn.unwrap(value): java.lang.String
        )
      )(_.authorizerArn)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CreateAuthorizerResponse.ReadOnly =
    zio.aws.iot.model.CreateAuthorizerResponse.wrap(buildAwsValue())
}
object CreateAuthorizerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreateAuthorizerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreateAuthorizerResponse =
      zio.aws.iot.model.CreateAuthorizerResponse(
        authorizerName.map(value => value),
        authorizerArn.map(value => value)
      )
    def authorizerName: Optional[AuthorizerName]
    def authorizerArn: Optional[AuthorizerArn]
    def getAuthorizerName: ZIO[Any, AwsError, AuthorizerName] =
      AwsError.unwrapOptionField("authorizerName", authorizerName)
    def getAuthorizerArn: ZIO[Any, AwsError, AuthorizerArn] =
      AwsError.unwrapOptionField("authorizerArn", authorizerArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreateAuthorizerResponse
  ) extends zio.aws.iot.model.CreateAuthorizerResponse.ReadOnly {
    override val authorizerName: Optional[AuthorizerName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authorizerName())
        .map(value => zio.aws.iot.model.primitives.AuthorizerName(value))
    override val authorizerArn: Optional[AuthorizerArn] = zio.aws.core.internal
      .optionalFromNullable(impl.authorizerArn())
      .map(value => zio.aws.iot.model.primitives.AuthorizerArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreateAuthorizerResponse
  ): zio.aws.iot.model.CreateAuthorizerResponse.ReadOnly = new Wrapper(impl)
}
