package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  CertificatePem,
  CertificateId,
  CertificateArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateCertificateFromCsrResponse(
    certificateArn: Optional[CertificateArn] = Optional.Absent,
    certificateId: Optional[CertificateId] = Optional.Absent,
    certificatePem: Optional[CertificatePem] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreateCertificateFromCsrResponse = {
    import CreateCertificateFromCsrResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreateCertificateFromCsrResponse
      .builder()
      .optionallyWith(
        certificateArn.map(value =>
          CertificateArn.unwrap(value): java.lang.String
        )
      )(_.certificateArn)
      .optionallyWith(
        certificateId.map(value =>
          CertificateId.unwrap(value): java.lang.String
        )
      )(_.certificateId)
      .optionallyWith(
        certificatePem.map(value =>
          CertificatePem.unwrap(value): java.lang.String
        )
      )(_.certificatePem)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CreateCertificateFromCsrResponse.ReadOnly =
    zio.aws.iot.model.CreateCertificateFromCsrResponse.wrap(buildAwsValue())
}
object CreateCertificateFromCsrResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreateCertificateFromCsrResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreateCertificateFromCsrResponse =
      zio.aws.iot.model.CreateCertificateFromCsrResponse(
        certificateArn.map(value => value),
        certificateId.map(value => value),
        certificatePem.map(value => value)
      )
    def certificateArn: Optional[CertificateArn]
    def certificateId: Optional[CertificateId]
    def certificatePem: Optional[CertificatePem]
    def getCertificateArn: ZIO[Any, AwsError, CertificateArn] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
    def getCertificateId: ZIO[Any, AwsError, CertificateId] =
      AwsError.unwrapOptionField("certificateId", certificateId)
    def getCertificatePem: ZIO[Any, AwsError, CertificatePem] =
      AwsError.unwrapOptionField("certificatePem", certificatePem)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreateCertificateFromCsrResponse
  ) extends zio.aws.iot.model.CreateCertificateFromCsrResponse.ReadOnly {
    override val certificateArn: Optional[CertificateArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateArn())
        .map(value => zio.aws.iot.model.primitives.CertificateArn(value))
    override val certificateId: Optional[CertificateId] = zio.aws.core.internal
      .optionalFromNullable(impl.certificateId())
      .map(value => zio.aws.iot.model.primitives.CertificateId(value))
    override val certificatePem: Optional[CertificatePem] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificatePem())
        .map(value => zio.aws.iot.model.primitives.CertificatePem(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreateCertificateFromCsrResponse
  ): zio.aws.iot.model.CreateCertificateFromCsrResponse.ReadOnly = new Wrapper(
    impl
  )
}
