package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{CustomMetricArn, MetricName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateCustomMetricResponse(
    metricName: Optional[MetricName] = Optional.Absent,
    metricArn: Optional[CustomMetricArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreateCustomMetricResponse = {
    import CreateCustomMetricResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreateCustomMetricResponse
      .builder()
      .optionallyWith(
        metricName.map(value => MetricName.unwrap(value): java.lang.String)
      )(_.metricName)
      .optionallyWith(
        metricArn.map(value => CustomMetricArn.unwrap(value): java.lang.String)
      )(_.metricArn)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CreateCustomMetricResponse.ReadOnly =
    zio.aws.iot.model.CreateCustomMetricResponse.wrap(buildAwsValue())
}
object CreateCustomMetricResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreateCustomMetricResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreateCustomMetricResponse =
      zio.aws.iot.model.CreateCustomMetricResponse(
        metricName.map(value => value),
        metricArn.map(value => value)
      )
    def metricName: Optional[MetricName]
    def metricArn: Optional[CustomMetricArn]
    def getMetricName: ZIO[Any, AwsError, MetricName] =
      AwsError.unwrapOptionField("metricName", metricName)
    def getMetricArn: ZIO[Any, AwsError, CustomMetricArn] =
      AwsError.unwrapOptionField("metricArn", metricArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreateCustomMetricResponse
  ) extends zio.aws.iot.model.CreateCustomMetricResponse.ReadOnly {
    override val metricName: Optional[MetricName] = zio.aws.core.internal
      .optionalFromNullable(impl.metricName())
      .map(value => zio.aws.iot.model.primitives.MetricName(value))
    override val metricArn: Optional[CustomMetricArn] = zio.aws.core.internal
      .optionalFromNullable(impl.metricArn())
      .map(value => zio.aws.iot.model.primitives.CustomMetricArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreateCustomMetricResponse
  ): zio.aws.iot.model.CreateCustomMetricResponse.ReadOnly = new Wrapper(impl)
}
