package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  DomainConfigurationArn,
  DomainConfigurationName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateDomainConfigurationResponse(
    domainConfigurationName: Optional[DomainConfigurationName] =
      Optional.Absent,
    domainConfigurationArn: Optional[DomainConfigurationArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreateDomainConfigurationResponse = {
    import CreateDomainConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreateDomainConfigurationResponse
      .builder()
      .optionallyWith(
        domainConfigurationName.map(value =>
          DomainConfigurationName.unwrap(value): java.lang.String
        )
      )(_.domainConfigurationName)
      .optionallyWith(
        domainConfigurationArn.map(value =>
          DomainConfigurationArn.unwrap(value): java.lang.String
        )
      )(_.domainConfigurationArn)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CreateDomainConfigurationResponse.ReadOnly =
    zio.aws.iot.model.CreateDomainConfigurationResponse.wrap(buildAwsValue())
}
object CreateDomainConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreateDomainConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreateDomainConfigurationResponse =
      zio.aws.iot.model.CreateDomainConfigurationResponse(
        domainConfigurationName.map(value => value),
        domainConfigurationArn.map(value => value)
      )
    def domainConfigurationName: Optional[DomainConfigurationName]
    def domainConfigurationArn: Optional[DomainConfigurationArn]
    def getDomainConfigurationName
        : ZIO[Any, AwsError, DomainConfigurationName] = AwsError
      .unwrapOptionField("domainConfigurationName", domainConfigurationName)
    def getDomainConfigurationArn: ZIO[Any, AwsError, DomainConfigurationArn] =
      AwsError.unwrapOptionField(
        "domainConfigurationArn",
        domainConfigurationArn
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreateDomainConfigurationResponse
  ) extends zio.aws.iot.model.CreateDomainConfigurationResponse.ReadOnly {
    override val domainConfigurationName: Optional[DomainConfigurationName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domainConfigurationName())
        .map(value =>
          zio.aws.iot.model.primitives.DomainConfigurationName(value)
        )
    override val domainConfigurationArn: Optional[DomainConfigurationArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domainConfigurationArn())
        .map(value =>
          zio.aws.iot.model.primitives.DomainConfigurationArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreateDomainConfigurationResponse
  ): zio.aws.iot.model.CreateDomainConfigurationResponse.ReadOnly = new Wrapper(
    impl
  )
}
