package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  CertificatePem,
  CertificateId,
  CertificateArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateKeysAndCertificateResponse(
    certificateArn: Optional[CertificateArn] = Optional.Absent,
    certificateId: Optional[CertificateId] = Optional.Absent,
    certificatePem: Optional[CertificatePem] = Optional.Absent,
    keyPair: Optional[zio.aws.iot.model.KeyPair] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreateKeysAndCertificateResponse = {
    import CreateKeysAndCertificateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreateKeysAndCertificateResponse
      .builder()
      .optionallyWith(
        certificateArn.map(value =>
          CertificateArn.unwrap(value): java.lang.String
        )
      )(_.certificateArn)
      .optionallyWith(
        certificateId.map(value =>
          CertificateId.unwrap(value): java.lang.String
        )
      )(_.certificateId)
      .optionallyWith(
        certificatePem.map(value =>
          CertificatePem.unwrap(value): java.lang.String
        )
      )(_.certificatePem)
      .optionallyWith(keyPair.map(value => value.buildAwsValue()))(_.keyPair)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CreateKeysAndCertificateResponse.ReadOnly =
    zio.aws.iot.model.CreateKeysAndCertificateResponse.wrap(buildAwsValue())
}
object CreateKeysAndCertificateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreateKeysAndCertificateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreateKeysAndCertificateResponse =
      zio.aws.iot.model.CreateKeysAndCertificateResponse(
        certificateArn.map(value => value),
        certificateId.map(value => value),
        certificatePem.map(value => value),
        keyPair.map(value => value.asEditable)
      )
    def certificateArn: Optional[CertificateArn]
    def certificateId: Optional[CertificateId]
    def certificatePem: Optional[CertificatePem]
    def keyPair: Optional[zio.aws.iot.model.KeyPair.ReadOnly]
    def getCertificateArn: ZIO[Any, AwsError, CertificateArn] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
    def getCertificateId: ZIO[Any, AwsError, CertificateId] =
      AwsError.unwrapOptionField("certificateId", certificateId)
    def getCertificatePem: ZIO[Any, AwsError, CertificatePem] =
      AwsError.unwrapOptionField("certificatePem", certificatePem)
    def getKeyPair: ZIO[Any, AwsError, zio.aws.iot.model.KeyPair.ReadOnly] =
      AwsError.unwrapOptionField("keyPair", keyPair)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreateKeysAndCertificateResponse
  ) extends zio.aws.iot.model.CreateKeysAndCertificateResponse.ReadOnly {
    override val certificateArn: Optional[CertificateArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateArn())
        .map(value => zio.aws.iot.model.primitives.CertificateArn(value))
    override val certificateId: Optional[CertificateId] = zio.aws.core.internal
      .optionalFromNullable(impl.certificateId())
      .map(value => zio.aws.iot.model.primitives.CertificateId(value))
    override val certificatePem: Optional[CertificatePem] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificatePem())
        .map(value => zio.aws.iot.model.primitives.CertificatePem(value))
    override val keyPair: Optional[zio.aws.iot.model.KeyPair.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keyPair())
        .map(value => zio.aws.iot.model.KeyPair.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreateKeysAndCertificateResponse
  ): zio.aws.iot.model.CreateKeysAndCertificateResponse.ReadOnly = new Wrapper(
    impl
  )
}
