package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  AwsIotJobArn,
  OTAUpdateArn,
  AwsIotJobId,
  OTAUpdateId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateOtaUpdateResponse(
    otaUpdateId: Optional[OTAUpdateId] = Optional.Absent,
    awsIotJobId: Optional[AwsIotJobId] = Optional.Absent,
    otaUpdateArn: Optional[OTAUpdateArn] = Optional.Absent,
    awsIotJobArn: Optional[AwsIotJobArn] = Optional.Absent,
    otaUpdateStatus: Optional[zio.aws.iot.model.OTAUpdateStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreateOtaUpdateResponse = {
    import CreateOtaUpdateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreateOtaUpdateResponse
      .builder()
      .optionallyWith(
        otaUpdateId.map(value => OTAUpdateId.unwrap(value): java.lang.String)
      )(_.otaUpdateId)
      .optionallyWith(
        awsIotJobId.map(value => AwsIotJobId.unwrap(value): java.lang.String)
      )(_.awsIotJobId)
      .optionallyWith(
        otaUpdateArn.map(value => OTAUpdateArn.unwrap(value): java.lang.String)
      )(_.otaUpdateArn)
      .optionallyWith(
        awsIotJobArn.map(value => AwsIotJobArn.unwrap(value): java.lang.String)
      )(_.awsIotJobArn)
      .optionallyWith(otaUpdateStatus.map(value => value.unwrap))(
        _.otaUpdateStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CreateOtaUpdateResponse.ReadOnly =
    zio.aws.iot.model.CreateOtaUpdateResponse.wrap(buildAwsValue())
}
object CreateOtaUpdateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreateOtaUpdateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreateOtaUpdateResponse =
      zio.aws.iot.model.CreateOtaUpdateResponse(
        otaUpdateId.map(value => value),
        awsIotJobId.map(value => value),
        otaUpdateArn.map(value => value),
        awsIotJobArn.map(value => value),
        otaUpdateStatus.map(value => value)
      )
    def otaUpdateId: Optional[OTAUpdateId]
    def awsIotJobId: Optional[AwsIotJobId]
    def otaUpdateArn: Optional[OTAUpdateArn]
    def awsIotJobArn: Optional[AwsIotJobArn]
    def otaUpdateStatus: Optional[zio.aws.iot.model.OTAUpdateStatus]
    def getOtaUpdateId: ZIO[Any, AwsError, OTAUpdateId] =
      AwsError.unwrapOptionField("otaUpdateId", otaUpdateId)
    def getAwsIotJobId: ZIO[Any, AwsError, AwsIotJobId] =
      AwsError.unwrapOptionField("awsIotJobId", awsIotJobId)
    def getOtaUpdateArn: ZIO[Any, AwsError, OTAUpdateArn] =
      AwsError.unwrapOptionField("otaUpdateArn", otaUpdateArn)
    def getAwsIotJobArn: ZIO[Any, AwsError, AwsIotJobArn] =
      AwsError.unwrapOptionField("awsIotJobArn", awsIotJobArn)
    def getOtaUpdateStatus
        : ZIO[Any, AwsError, zio.aws.iot.model.OTAUpdateStatus] =
      AwsError.unwrapOptionField("otaUpdateStatus", otaUpdateStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreateOtaUpdateResponse
  ) extends zio.aws.iot.model.CreateOtaUpdateResponse.ReadOnly {
    override val otaUpdateId: Optional[OTAUpdateId] = zio.aws.core.internal
      .optionalFromNullable(impl.otaUpdateId())
      .map(value => zio.aws.iot.model.primitives.OTAUpdateId(value))
    override val awsIotJobId: Optional[AwsIotJobId] = zio.aws.core.internal
      .optionalFromNullable(impl.awsIotJobId())
      .map(value => zio.aws.iot.model.primitives.AwsIotJobId(value))
    override val otaUpdateArn: Optional[OTAUpdateArn] = zio.aws.core.internal
      .optionalFromNullable(impl.otaUpdateArn())
      .map(value => zio.aws.iot.model.primitives.OTAUpdateArn(value))
    override val awsIotJobArn: Optional[AwsIotJobArn] = zio.aws.core.internal
      .optionalFromNullable(impl.awsIotJobArn())
      .map(value => zio.aws.iot.model.primitives.AwsIotJobArn(value))
    override val otaUpdateStatus: Optional[zio.aws.iot.model.OTAUpdateStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.otaUpdateStatus())
        .map(value => zio.aws.iot.model.OTAUpdateStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreateOtaUpdateResponse
  ): zio.aws.iot.model.CreateOtaUpdateResponse.ReadOnly = new Wrapper(impl)
}
