package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  IsDefaultVersion,
  PolicyVersionId,
  PolicyDocument,
  PolicyArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreatePolicyVersionResponse(
    policyArn: Optional[PolicyArn] = Optional.Absent,
    policyDocument: Optional[PolicyDocument] = Optional.Absent,
    policyVersionId: Optional[PolicyVersionId] = Optional.Absent,
    isDefaultVersion: Optional[IsDefaultVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreatePolicyVersionResponse = {
    import CreatePolicyVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreatePolicyVersionResponse
      .builder()
      .optionallyWith(
        policyArn.map(value => PolicyArn.unwrap(value): java.lang.String)
      )(_.policyArn)
      .optionallyWith(
        policyDocument.map(value =>
          PolicyDocument.unwrap(value): java.lang.String
        )
      )(_.policyDocument)
      .optionallyWith(
        policyVersionId.map(value =>
          PolicyVersionId.unwrap(value): java.lang.String
        )
      )(_.policyVersionId)
      .optionallyWith(
        isDefaultVersion.map(value =>
          IsDefaultVersion.unwrap(value): java.lang.Boolean
        )
      )(_.isDefaultVersion)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CreatePolicyVersionResponse.ReadOnly =
    zio.aws.iot.model.CreatePolicyVersionResponse.wrap(buildAwsValue())
}
object CreatePolicyVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreatePolicyVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreatePolicyVersionResponse =
      zio.aws.iot.model.CreatePolicyVersionResponse(
        policyArn.map(value => value),
        policyDocument.map(value => value),
        policyVersionId.map(value => value),
        isDefaultVersion.map(value => value)
      )
    def policyArn: Optional[PolicyArn]
    def policyDocument: Optional[PolicyDocument]
    def policyVersionId: Optional[PolicyVersionId]
    def isDefaultVersion: Optional[IsDefaultVersion]
    def getPolicyArn: ZIO[Any, AwsError, PolicyArn] =
      AwsError.unwrapOptionField("policyArn", policyArn)
    def getPolicyDocument: ZIO[Any, AwsError, PolicyDocument] =
      AwsError.unwrapOptionField("policyDocument", policyDocument)
    def getPolicyVersionId: ZIO[Any, AwsError, PolicyVersionId] =
      AwsError.unwrapOptionField("policyVersionId", policyVersionId)
    def getIsDefaultVersion: ZIO[Any, AwsError, IsDefaultVersion] =
      AwsError.unwrapOptionField("isDefaultVersion", isDefaultVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreatePolicyVersionResponse
  ) extends zio.aws.iot.model.CreatePolicyVersionResponse.ReadOnly {
    override val policyArn: Optional[PolicyArn] = zio.aws.core.internal
      .optionalFromNullable(impl.policyArn())
      .map(value => zio.aws.iot.model.primitives.PolicyArn(value))
    override val policyDocument: Optional[PolicyDocument] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policyDocument())
        .map(value => zio.aws.iot.model.primitives.PolicyDocument(value))
    override val policyVersionId: Optional[PolicyVersionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policyVersionId())
        .map(value => zio.aws.iot.model.primitives.PolicyVersionId(value))
    override val isDefaultVersion: Optional[IsDefaultVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.isDefaultVersion())
        .map(value => zio.aws.iot.model.primitives.IsDefaultVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreatePolicyVersionResponse
  ): zio.aws.iot.model.CreatePolicyVersionResponse.ReadOnly = new Wrapper(impl)
}
