package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.TemplateName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateProvisioningClaimRequest(templateName: TemplateName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreateProvisioningClaimRequest = {
    import CreateProvisioningClaimRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreateProvisioningClaimRequest
      .builder()
      .templateName(TemplateName.unwrap(templateName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CreateProvisioningClaimRequest.ReadOnly =
    zio.aws.iot.model.CreateProvisioningClaimRequest.wrap(buildAwsValue())
}
object CreateProvisioningClaimRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreateProvisioningClaimRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreateProvisioningClaimRequest =
      zio.aws.iot.model.CreateProvisioningClaimRequest(templateName)
    def templateName: TemplateName
    def getTemplateName: ZIO[Any, Nothing, TemplateName] =
      ZIO.succeed(templateName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreateProvisioningClaimRequest
  ) extends zio.aws.iot.model.CreateProvisioningClaimRequest.ReadOnly {
    override val templateName: TemplateName =
      zio.aws.iot.model.primitives.TemplateName(impl.templateName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreateProvisioningClaimRequest
  ): zio.aws.iot.model.CreateProvisioningClaimRequest.ReadOnly = new Wrapper(
    impl
  )
}
