package zio.aws.iot.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{DateType, CertificatePem, CertificateId}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class CreateProvisioningClaimResponse(
    certificateId: Optional[CertificateId] = Optional.Absent,
    certificatePem: Optional[CertificatePem] = Optional.Absent,
    keyPair: Optional[zio.aws.iot.model.KeyPair] = Optional.Absent,
    expiration: Optional[DateType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreateProvisioningClaimResponse = {
    import CreateProvisioningClaimResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreateProvisioningClaimResponse
      .builder()
      .optionallyWith(
        certificateId.map(value =>
          CertificateId.unwrap(value): java.lang.String
        )
      )(_.certificateId)
      .optionallyWith(
        certificatePem.map(value =>
          CertificatePem.unwrap(value): java.lang.String
        )
      )(_.certificatePem)
      .optionallyWith(keyPair.map(value => value.buildAwsValue()))(_.keyPair)
      .optionallyWith(expiration.map(value => DateType.unwrap(value): Instant))(
        _.expiration
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CreateProvisioningClaimResponse.ReadOnly =
    zio.aws.iot.model.CreateProvisioningClaimResponse.wrap(buildAwsValue())
}
object CreateProvisioningClaimResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreateProvisioningClaimResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreateProvisioningClaimResponse =
      zio.aws.iot.model.CreateProvisioningClaimResponse(
        certificateId.map(value => value),
        certificatePem.map(value => value),
        keyPair.map(value => value.asEditable),
        expiration.map(value => value)
      )
    def certificateId: Optional[CertificateId]
    def certificatePem: Optional[CertificatePem]
    def keyPair: Optional[zio.aws.iot.model.KeyPair.ReadOnly]
    def expiration: Optional[DateType]
    def getCertificateId: ZIO[Any, AwsError, CertificateId] =
      AwsError.unwrapOptionField("certificateId", certificateId)
    def getCertificatePem: ZIO[Any, AwsError, CertificatePem] =
      AwsError.unwrapOptionField("certificatePem", certificatePem)
    def getKeyPair: ZIO[Any, AwsError, zio.aws.iot.model.KeyPair.ReadOnly] =
      AwsError.unwrapOptionField("keyPair", keyPair)
    def getExpiration: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("expiration", expiration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreateProvisioningClaimResponse
  ) extends zio.aws.iot.model.CreateProvisioningClaimResponse.ReadOnly {
    override val certificateId: Optional[CertificateId] = zio.aws.core.internal
      .optionalFromNullable(impl.certificateId())
      .map(value => zio.aws.iot.model.primitives.CertificateId(value))
    override val certificatePem: Optional[CertificatePem] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificatePem())
        .map(value => zio.aws.iot.model.primitives.CertificatePem(value))
    override val keyPair: Optional[zio.aws.iot.model.KeyPair.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keyPair())
        .map(value => zio.aws.iot.model.KeyPair.wrap(value))
    override val expiration: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.expiration())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreateProvisioningClaimResponse
  ): zio.aws.iot.model.CreateProvisioningClaimResponse.ReadOnly = new Wrapper(
    impl
  )
}
