package zio.aws.iot.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  TemplateVersionId,
  TemplateName,
  TemplateArn
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CreateProvisioningTemplateResponse(
    templateArn: Optional[TemplateArn] = Optional.Absent,
    templateName: Optional[TemplateName] = Optional.Absent,
    defaultVersionId: Optional[TemplateVersionId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreateProvisioningTemplateResponse = {
    import CreateProvisioningTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreateProvisioningTemplateResponse
      .builder()
      .optionallyWith(
        templateArn.map(value => TemplateArn.unwrap(value): java.lang.String)
      )(_.templateArn)
      .optionallyWith(
        templateName.map(value => TemplateName.unwrap(value): java.lang.String)
      )(_.templateName)
      .optionallyWith(
        defaultVersionId.map(value => TemplateVersionId.unwrap(value): Integer)
      )(_.defaultVersionId)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.CreateProvisioningTemplateResponse.ReadOnly =
    zio.aws.iot.model.CreateProvisioningTemplateResponse.wrap(buildAwsValue())
}
object CreateProvisioningTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreateProvisioningTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreateProvisioningTemplateResponse =
      zio.aws.iot.model.CreateProvisioningTemplateResponse(
        templateArn.map(value => value),
        templateName.map(value => value),
        defaultVersionId.map(value => value)
      )
    def templateArn: Optional[TemplateArn]
    def templateName: Optional[TemplateName]
    def defaultVersionId: Optional[TemplateVersionId]
    def getTemplateArn: ZIO[Any, AwsError, TemplateArn] =
      AwsError.unwrapOptionField("templateArn", templateArn)
    def getTemplateName: ZIO[Any, AwsError, TemplateName] =
      AwsError.unwrapOptionField("templateName", templateName)
    def getDefaultVersionId: ZIO[Any, AwsError, TemplateVersionId] =
      AwsError.unwrapOptionField("defaultVersionId", defaultVersionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreateProvisioningTemplateResponse
  ) extends zio.aws.iot.model.CreateProvisioningTemplateResponse.ReadOnly {
    override val templateArn: Optional[TemplateArn] = zio.aws.core.internal
      .optionalFromNullable(impl.templateArn())
      .map(value => zio.aws.iot.model.primitives.TemplateArn(value))
    override val templateName: Optional[TemplateName] = zio.aws.core.internal
      .optionalFromNullable(impl.templateName())
      .map(value => zio.aws.iot.model.primitives.TemplateName(value))
    override val defaultVersionId: Optional[TemplateVersionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultVersionId())
        .map(value => zio.aws.iot.model.primitives.TemplateVersionId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreateProvisioningTemplateResponse
  ): zio.aws.iot.model.CreateProvisioningTemplateResponse.ReadOnly =
    new Wrapper(impl)
}
