package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{RoleAliasArn, RoleAlias}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateRoleAliasResponse(
    roleAlias: Optional[RoleAlias] = Optional.Absent,
    roleAliasArn: Optional[RoleAliasArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreateRoleAliasResponse = {
    import CreateRoleAliasResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreateRoleAliasResponse
      .builder()
      .optionallyWith(
        roleAlias.map(value => RoleAlias.unwrap(value): java.lang.String)
      )(_.roleAlias)
      .optionallyWith(
        roleAliasArn.map(value => RoleAliasArn.unwrap(value): java.lang.String)
      )(_.roleAliasArn)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CreateRoleAliasResponse.ReadOnly =
    zio.aws.iot.model.CreateRoleAliasResponse.wrap(buildAwsValue())
}
object CreateRoleAliasResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreateRoleAliasResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreateRoleAliasResponse =
      zio.aws.iot.model.CreateRoleAliasResponse(
        roleAlias.map(value => value),
        roleAliasArn.map(value => value)
      )
    def roleAlias: Optional[RoleAlias]
    def roleAliasArn: Optional[RoleAliasArn]
    def getRoleAlias: ZIO[Any, AwsError, RoleAlias] =
      AwsError.unwrapOptionField("roleAlias", roleAlias)
    def getRoleAliasArn: ZIO[Any, AwsError, RoleAliasArn] =
      AwsError.unwrapOptionField("roleAliasArn", roleAliasArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreateRoleAliasResponse
  ) extends zio.aws.iot.model.CreateRoleAliasResponse.ReadOnly {
    override val roleAlias: Optional[RoleAlias] = zio.aws.core.internal
      .optionalFromNullable(impl.roleAlias())
      .map(value => zio.aws.iot.model.primitives.RoleAlias(value))
    override val roleAliasArn: Optional[RoleAliasArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleAliasArn())
      .map(value => zio.aws.iot.model.primitives.RoleAliasArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreateRoleAliasResponse
  ): zio.aws.iot.model.CreateRoleAliasResponse.ReadOnly = new Wrapper(impl)
}
