package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  ScheduledAuditName,
  AuditCheckName,
  DayOfMonth
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateScheduledAuditRequest(
    frequency: zio.aws.iot.model.AuditFrequency,
    dayOfMonth: Optional[DayOfMonth] = Optional.Absent,
    dayOfWeek: Optional[zio.aws.iot.model.DayOfWeek] = Optional.Absent,
    targetCheckNames: Iterable[AuditCheckName],
    scheduledAuditName: ScheduledAuditName,
    tags: Optional[Iterable[zio.aws.iot.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreateScheduledAuditRequest = {
    import CreateScheduledAuditRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreateScheduledAuditRequest
      .builder()
      .frequency(frequency.unwrap)
      .optionallyWith(
        dayOfMonth.map(value => DayOfMonth.unwrap(value): java.lang.String)
      )(_.dayOfMonth)
      .optionallyWith(dayOfWeek.map(value => value.unwrap))(_.dayOfWeek)
      .targetCheckNames(targetCheckNames.map { item =>
        AuditCheckName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .scheduledAuditName(
        ScheduledAuditName.unwrap(scheduledAuditName): java.lang.String
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CreateScheduledAuditRequest.ReadOnly =
    zio.aws.iot.model.CreateScheduledAuditRequest.wrap(buildAwsValue())
}
object CreateScheduledAuditRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreateScheduledAuditRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreateScheduledAuditRequest =
      zio.aws.iot.model.CreateScheduledAuditRequest(
        frequency,
        dayOfMonth.map(value => value),
        dayOfWeek.map(value => value),
        targetCheckNames,
        scheduledAuditName,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def frequency: zio.aws.iot.model.AuditFrequency
    def dayOfMonth: Optional[DayOfMonth]
    def dayOfWeek: Optional[zio.aws.iot.model.DayOfWeek]
    def targetCheckNames: List[AuditCheckName]
    def scheduledAuditName: ScheduledAuditName
    def tags: Optional[List[zio.aws.iot.model.Tag.ReadOnly]]
    def getFrequency: ZIO[Any, Nothing, zio.aws.iot.model.AuditFrequency] =
      ZIO.succeed(frequency)
    def getDayOfMonth: ZIO[Any, AwsError, DayOfMonth] =
      AwsError.unwrapOptionField("dayOfMonth", dayOfMonth)
    def getDayOfWeek: ZIO[Any, AwsError, zio.aws.iot.model.DayOfWeek] =
      AwsError.unwrapOptionField("dayOfWeek", dayOfWeek)
    def getTargetCheckNames: ZIO[Any, Nothing, List[AuditCheckName]] =
      ZIO.succeed(targetCheckNames)
    def getScheduledAuditName: ZIO[Any, Nothing, ScheduledAuditName] =
      ZIO.succeed(scheduledAuditName)
    def getTags: ZIO[Any, AwsError, List[zio.aws.iot.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreateScheduledAuditRequest
  ) extends zio.aws.iot.model.CreateScheduledAuditRequest.ReadOnly {
    override val frequency: zio.aws.iot.model.AuditFrequency =
      zio.aws.iot.model.AuditFrequency.wrap(impl.frequency())
    override val dayOfMonth: Optional[DayOfMonth] = zio.aws.core.internal
      .optionalFromNullable(impl.dayOfMonth())
      .map(value => zio.aws.iot.model.primitives.DayOfMonth(value))
    override val dayOfWeek: Optional[zio.aws.iot.model.DayOfWeek] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dayOfWeek())
        .map(value => zio.aws.iot.model.DayOfWeek.wrap(value))
    override val targetCheckNames: List[AuditCheckName] = impl
      .targetCheckNames()
      .asScala
      .map { item =>
        zio.aws.iot.model.primitives.AuditCheckName(item)
      }
      .toList
    override val scheduledAuditName: ScheduledAuditName =
      zio.aws.iot.model.primitives.ScheduledAuditName(impl.scheduledAuditName())
    override val tags: Optional[List[zio.aws.iot.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreateScheduledAuditRequest
  ): zio.aws.iot.model.CreateScheduledAuditRequest.ReadOnly = new Wrapper(impl)
}
