package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{ThingTypeId, ThingTypeArn, ThingTypeName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateThingTypeResponse(
    thingTypeName: Optional[ThingTypeName] = Optional.Absent,
    thingTypeArn: Optional[ThingTypeArn] = Optional.Absent,
    thingTypeId: Optional[ThingTypeId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreateThingTypeResponse = {
    import CreateThingTypeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreateThingTypeResponse
      .builder()
      .optionallyWith(
        thingTypeName.map(value =>
          ThingTypeName.unwrap(value): java.lang.String
        )
      )(_.thingTypeName)
      .optionallyWith(
        thingTypeArn.map(value => ThingTypeArn.unwrap(value): java.lang.String)
      )(_.thingTypeArn)
      .optionallyWith(
        thingTypeId.map(value => ThingTypeId.unwrap(value): java.lang.String)
      )(_.thingTypeId)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CreateThingTypeResponse.ReadOnly =
    zio.aws.iot.model.CreateThingTypeResponse.wrap(buildAwsValue())
}
object CreateThingTypeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreateThingTypeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreateThingTypeResponse =
      zio.aws.iot.model.CreateThingTypeResponse(
        thingTypeName.map(value => value),
        thingTypeArn.map(value => value),
        thingTypeId.map(value => value)
      )
    def thingTypeName: Optional[ThingTypeName]
    def thingTypeArn: Optional[ThingTypeArn]
    def thingTypeId: Optional[ThingTypeId]
    def getThingTypeName: ZIO[Any, AwsError, ThingTypeName] =
      AwsError.unwrapOptionField("thingTypeName", thingTypeName)
    def getThingTypeArn: ZIO[Any, AwsError, ThingTypeArn] =
      AwsError.unwrapOptionField("thingTypeArn", thingTypeArn)
    def getThingTypeId: ZIO[Any, AwsError, ThingTypeId] =
      AwsError.unwrapOptionField("thingTypeId", thingTypeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreateThingTypeResponse
  ) extends zio.aws.iot.model.CreateThingTypeResponse.ReadOnly {
    override val thingTypeName: Optional[ThingTypeName] = zio.aws.core.internal
      .optionalFromNullable(impl.thingTypeName())
      .map(value => zio.aws.iot.model.primitives.ThingTypeName(value))
    override val thingTypeArn: Optional[ThingTypeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.thingTypeArn())
      .map(value => zio.aws.iot.model.primitives.ThingTypeArn(value))
    override val thingTypeId: Optional[ThingTypeId] = zio.aws.core.internal
      .optionalFromNullable(impl.thingTypeId())
      .map(value => zio.aws.iot.model.primitives.ThingTypeId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreateThingTypeResponse
  ): zio.aws.iot.model.CreateThingTypeResponse.ReadOnly = new Wrapper(impl)
}
