package zio.aws.iot.model
import scala.jdk.CollectionConverters._
sealed trait CustomMetricType {
  def unwrap: software.amazon.awssdk.services.iot.model.CustomMetricType
}
object CustomMetricType {
  def wrap(
      value: software.amazon.awssdk.services.iot.model.CustomMetricType
  ): zio.aws.iot.model.CustomMetricType = value match {
    case software.amazon.awssdk.services.iot.model.CustomMetricType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iot.model.CustomMetricType.STRING_LIST =>
      val r = `string-list`
      r
    case software.amazon.awssdk.services.iot.model.CustomMetricType.IP_ADDRESS_LIST =>
      val r = `ip-address-list`
      r
    case software.amazon.awssdk.services.iot.model.CustomMetricType.NUMBER_LIST =>
      val r = `number-list`
      r
    case software.amazon.awssdk.services.iot.model.CustomMetricType.NUMBER =>
      val r = number
      r
  }
  case object unknownToSdkVersion extends zio.aws.iot.model.CustomMetricType {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.CustomMetricType =
      software.amazon.awssdk.services.iot.model.CustomMetricType.UNKNOWN_TO_SDK_VERSION
  }
  case object `string-list` extends zio.aws.iot.model.CustomMetricType {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.CustomMetricType =
      software.amazon.awssdk.services.iot.model.CustomMetricType.STRING_LIST
  }
  case object `ip-address-list` extends zio.aws.iot.model.CustomMetricType {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.CustomMetricType =
      software.amazon.awssdk.services.iot.model.CustomMetricType.IP_ADDRESS_LIST
  }
  case object `number-list` extends zio.aws.iot.model.CustomMetricType {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.CustomMetricType =
      software.amazon.awssdk.services.iot.model.CustomMetricType.NUMBER_LIST
  }
  case object number extends zio.aws.iot.model.CustomMetricType {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.CustomMetricType =
      software.amazon.awssdk.services.iot.model.CustomMetricType.NUMBER
  }
}
