package zio.aws.iot.model
import scala.jdk.CollectionConverters._
sealed trait DayOfWeek {
  def unwrap: software.amazon.awssdk.services.iot.model.DayOfWeek
}
object DayOfWeek {
  def wrap(
      value: software.amazon.awssdk.services.iot.model.DayOfWeek
  ): zio.aws.iot.model.DayOfWeek = value match {
    case software.amazon.awssdk.services.iot.model.DayOfWeek.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iot.model.DayOfWeek.SUN =>
      val r = SUN
      r
    case software.amazon.awssdk.services.iot.model.DayOfWeek.MON =>
      val r = MON
      r
    case software.amazon.awssdk.services.iot.model.DayOfWeek.TUE =>
      val r = TUE
      r
    case software.amazon.awssdk.services.iot.model.DayOfWeek.WED =>
      val r = WED
      r
    case software.amazon.awssdk.services.iot.model.DayOfWeek.THU =>
      val r = THU
      r
    case software.amazon.awssdk.services.iot.model.DayOfWeek.FRI =>
      val r = FRI
      r
    case software.amazon.awssdk.services.iot.model.DayOfWeek.SAT =>
      val r = SAT
      r
  }
  case object unknownToSdkVersion extends zio.aws.iot.model.DayOfWeek {
    override def unwrap: software.amazon.awssdk.services.iot.model.DayOfWeek =
      software.amazon.awssdk.services.iot.model.DayOfWeek.UNKNOWN_TO_SDK_VERSION
  }
  case object SUN extends zio.aws.iot.model.DayOfWeek {
    override def unwrap: software.amazon.awssdk.services.iot.model.DayOfWeek =
      software.amazon.awssdk.services.iot.model.DayOfWeek.SUN
  }
  case object MON extends zio.aws.iot.model.DayOfWeek {
    override def unwrap: software.amazon.awssdk.services.iot.model.DayOfWeek =
      software.amazon.awssdk.services.iot.model.DayOfWeek.MON
  }
  case object TUE extends zio.aws.iot.model.DayOfWeek {
    override def unwrap: software.amazon.awssdk.services.iot.model.DayOfWeek =
      software.amazon.awssdk.services.iot.model.DayOfWeek.TUE
  }
  case object WED extends zio.aws.iot.model.DayOfWeek {
    override def unwrap: software.amazon.awssdk.services.iot.model.DayOfWeek =
      software.amazon.awssdk.services.iot.model.DayOfWeek.WED
  }
  case object THU extends zio.aws.iot.model.DayOfWeek {
    override def unwrap: software.amazon.awssdk.services.iot.model.DayOfWeek =
      software.amazon.awssdk.services.iot.model.DayOfWeek.THU
  }
  case object FRI extends zio.aws.iot.model.DayOfWeek {
    override def unwrap: software.amazon.awssdk.services.iot.model.DayOfWeek =
      software.amazon.awssdk.services.iot.model.DayOfWeek.FRI
  }
  case object SAT extends zio.aws.iot.model.DayOfWeek {
    override def unwrap: software.amazon.awssdk.services.iot.model.DayOfWeek =
      software.amazon.awssdk.services.iot.model.DayOfWeek.SAT
  }
}
