package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.DeleteScheduledAudits
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteAccountAuditConfigurationRequest(
    deleteScheduledAudits: Optional[DeleteScheduledAudits] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DeleteAccountAuditConfigurationRequest = {
    import DeleteAccountAuditConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DeleteAccountAuditConfigurationRequest
      .builder()
      .optionallyWith(
        deleteScheduledAudits.map(value =>
          DeleteScheduledAudits.unwrap(value): java.lang.Boolean
        )
      )(_.deleteScheduledAudits)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.DeleteAccountAuditConfigurationRequest.ReadOnly =
    zio.aws.iot.model.DeleteAccountAuditConfigurationRequest
      .wrap(buildAwsValue())
}
object DeleteAccountAuditConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DeleteAccountAuditConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DeleteAccountAuditConfigurationRequest =
      zio.aws.iot.model.DeleteAccountAuditConfigurationRequest(
        deleteScheduledAudits.map(value => value)
      )
    def deleteScheduledAudits: Optional[DeleteScheduledAudits]
    def getDeleteScheduledAudits: ZIO[Any, AwsError, DeleteScheduledAudits] =
      AwsError.unwrapOptionField("deleteScheduledAudits", deleteScheduledAudits)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DeleteAccountAuditConfigurationRequest
  ) extends zio.aws.iot.model.DeleteAccountAuditConfigurationRequest.ReadOnly {
    override val deleteScheduledAudits: Optional[DeleteScheduledAudits] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deleteScheduledAudits())
        .map(value => zio.aws.iot.model.primitives.DeleteScheduledAudits(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DeleteAccountAuditConfigurationRequest
  ): zio.aws.iot.model.DeleteAccountAuditConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
