package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.AuthorizerName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteAuthorizerRequest(authorizerName: AuthorizerName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DeleteAuthorizerRequest = {
    import DeleteAuthorizerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DeleteAuthorizerRequest
      .builder()
      .authorizerName(AuthorizerName.unwrap(authorizerName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DeleteAuthorizerRequest.ReadOnly =
    zio.aws.iot.model.DeleteAuthorizerRequest.wrap(buildAwsValue())
}
object DeleteAuthorizerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DeleteAuthorizerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DeleteAuthorizerRequest =
      zio.aws.iot.model.DeleteAuthorizerRequest(authorizerName)
    def authorizerName: AuthorizerName
    def getAuthorizerName: ZIO[Any, Nothing, AuthorizerName] =
      ZIO.succeed(authorizerName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DeleteAuthorizerRequest
  ) extends zio.aws.iot.model.DeleteAuthorizerRequest.ReadOnly {
    override val authorizerName: AuthorizerName =
      zio.aws.iot.model.primitives.AuthorizerName(impl.authorizerName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DeleteAuthorizerRequest
  ): zio.aws.iot.model.DeleteAuthorizerRequest.ReadOnly = new Wrapper(impl)
}
