package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{OptionalVersion, BillingGroupName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteBillingGroupRequest(
    billingGroupName: BillingGroupName,
    expectedVersion: Optional[OptionalVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DeleteBillingGroupRequest = {
    import DeleteBillingGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DeleteBillingGroupRequest
      .builder()
      .billingGroupName(
        BillingGroupName.unwrap(billingGroupName): java.lang.String
      )
      .optionallyWith(
        expectedVersion.map(value =>
          OptionalVersion.unwrap(value): java.lang.Long
        )
      )(_.expectedVersion)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DeleteBillingGroupRequest.ReadOnly =
    zio.aws.iot.model.DeleteBillingGroupRequest.wrap(buildAwsValue())
}
object DeleteBillingGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DeleteBillingGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DeleteBillingGroupRequest =
      zio.aws.iot.model.DeleteBillingGroupRequest(
        billingGroupName,
        expectedVersion.map(value => value)
      )
    def billingGroupName: BillingGroupName
    def expectedVersion: Optional[OptionalVersion]
    def getBillingGroupName: ZIO[Any, Nothing, BillingGroupName] =
      ZIO.succeed(billingGroupName)
    def getExpectedVersion: ZIO[Any, AwsError, OptionalVersion] =
      AwsError.unwrapOptionField("expectedVersion", expectedVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DeleteBillingGroupRequest
  ) extends zio.aws.iot.model.DeleteBillingGroupRequest.ReadOnly {
    override val billingGroupName: BillingGroupName =
      zio.aws.iot.model.primitives.BillingGroupName(impl.billingGroupName())
    override val expectedVersion: Optional[OptionalVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expectedVersion())
        .map(value => zio.aws.iot.model.primitives.OptionalVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DeleteBillingGroupRequest
  ): zio.aws.iot.model.DeleteBillingGroupRequest.ReadOnly = new Wrapper(impl)
}
