package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{ForceDelete, CertificateId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteCertificateRequest(
    certificateId: CertificateId,
    forceDelete: Optional[ForceDelete] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DeleteCertificateRequest = {
    import DeleteCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DeleteCertificateRequest
      .builder()
      .certificateId(CertificateId.unwrap(certificateId): java.lang.String)
      .optionallyWith(
        forceDelete.map(value => ForceDelete.unwrap(value): java.lang.Boolean)
      )(_.forceDelete)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DeleteCertificateRequest.ReadOnly =
    zio.aws.iot.model.DeleteCertificateRequest.wrap(buildAwsValue())
}
object DeleteCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DeleteCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DeleteCertificateRequest =
      zio.aws.iot.model.DeleteCertificateRequest(
        certificateId,
        forceDelete.map(value => value)
      )
    def certificateId: CertificateId
    def forceDelete: Optional[ForceDelete]
    def getCertificateId: ZIO[Any, Nothing, CertificateId] =
      ZIO.succeed(certificateId)
    def getForceDelete: ZIO[Any, AwsError, ForceDelete] =
      AwsError.unwrapOptionField("forceDelete", forceDelete)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DeleteCertificateRequest
  ) extends zio.aws.iot.model.DeleteCertificateRequest.ReadOnly {
    override val certificateId: CertificateId =
      zio.aws.iot.model.primitives.CertificateId(impl.certificateId())
    override val forceDelete: Optional[ForceDelete] = zio.aws.core.internal
      .optionalFromNullable(impl.forceDelete())
      .map(value => zio.aws.iot.model.primitives.ForceDelete(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DeleteCertificateRequest
  ): zio.aws.iot.model.DeleteCertificateRequest.ReadOnly = new Wrapper(impl)
}
