package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.MetricName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteCustomMetricRequest(metricName: MetricName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DeleteCustomMetricRequest = {
    import DeleteCustomMetricRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DeleteCustomMetricRequest
      .builder()
      .metricName(MetricName.unwrap(metricName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DeleteCustomMetricRequest.ReadOnly =
    zio.aws.iot.model.DeleteCustomMetricRequest.wrap(buildAwsValue())
}
object DeleteCustomMetricRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DeleteCustomMetricRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DeleteCustomMetricRequest =
      zio.aws.iot.model.DeleteCustomMetricRequest(metricName)
    def metricName: MetricName
    def getMetricName: ZIO[Any, Nothing, MetricName] = ZIO.succeed(metricName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DeleteCustomMetricRequest
  ) extends zio.aws.iot.model.DeleteCustomMetricRequest.ReadOnly {
    override val metricName: MetricName =
      zio.aws.iot.model.primitives.MetricName(impl.metricName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DeleteCustomMetricRequest
  ): zio.aws.iot.model.DeleteCustomMetricRequest.ReadOnly = new Wrapper(impl)
}
