package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.DomainConfigurationName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteDomainConfigurationRequest(
    domainConfigurationName: DomainConfigurationName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DeleteDomainConfigurationRequest = {
    import DeleteDomainConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DeleteDomainConfigurationRequest
      .builder()
      .domainConfigurationName(
        DomainConfigurationName.unwrap(
          domainConfigurationName
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DeleteDomainConfigurationRequest.ReadOnly =
    zio.aws.iot.model.DeleteDomainConfigurationRequest.wrap(buildAwsValue())
}
object DeleteDomainConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DeleteDomainConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DeleteDomainConfigurationRequest =
      zio.aws.iot.model
        .DeleteDomainConfigurationRequest(domainConfigurationName)
    def domainConfigurationName: DomainConfigurationName
    def getDomainConfigurationName: ZIO[Any, Nothing, DomainConfigurationName] =
      ZIO.succeed(domainConfigurationName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DeleteDomainConfigurationRequest
  ) extends zio.aws.iot.model.DeleteDomainConfigurationRequest.ReadOnly {
    override val domainConfigurationName: DomainConfigurationName =
      zio.aws.iot.model.primitives
        .DomainConfigurationName(impl.domainConfigurationName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DeleteDomainConfigurationRequest
  ): zio.aws.iot.model.DeleteDomainConfigurationRequest.ReadOnly = new Wrapper(
    impl
  )
}
