package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{NamespaceId, ForceFlag, JobId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteJobRequest(
    jobId: JobId,
    force: Optional[ForceFlag] = Optional.Absent,
    namespaceId: Optional[NamespaceId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DeleteJobRequest = {
    import DeleteJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DeleteJobRequest
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .optionallyWith(
        force.map(value => ForceFlag.unwrap(value): java.lang.Boolean)
      )(_.force)
      .optionallyWith(
        namespaceId.map(value => NamespaceId.unwrap(value): java.lang.String)
      )(_.namespaceId)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DeleteJobRequest.ReadOnly =
    zio.aws.iot.model.DeleteJobRequest.wrap(buildAwsValue())
}
object DeleteJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DeleteJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DeleteJobRequest =
      zio.aws.iot.model.DeleteJobRequest(
        jobId,
        force.map(value => value),
        namespaceId.map(value => value)
      )
    def jobId: JobId
    def force: Optional[ForceFlag]
    def namespaceId: Optional[NamespaceId]
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getForce: ZIO[Any, AwsError, ForceFlag] =
      AwsError.unwrapOptionField("force", force)
    def getNamespaceId: ZIO[Any, AwsError, NamespaceId] =
      AwsError.unwrapOptionField("namespaceId", namespaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DeleteJobRequest
  ) extends zio.aws.iot.model.DeleteJobRequest.ReadOnly {
    override val jobId: JobId = zio.aws.iot.model.primitives.JobId(impl.jobId())
    override val force: Optional[ForceFlag] = zio.aws.core.internal
      .optionalFromNullable(impl.force())
      .map(value => zio.aws.iot.model.primitives.ForceFlag(value))
    override val namespaceId: Optional[NamespaceId] = zio.aws.core.internal
      .optionalFromNullable(impl.namespaceId())
      .map(value => zio.aws.iot.model.primitives.NamespaceId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DeleteJobRequest
  ): zio.aws.iot.model.DeleteJobRequest.ReadOnly = new Wrapper(impl)
}
