package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.JobTemplateId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteJobTemplateRequest(jobTemplateId: JobTemplateId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DeleteJobTemplateRequest = {
    import DeleteJobTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DeleteJobTemplateRequest
      .builder()
      .jobTemplateId(JobTemplateId.unwrap(jobTemplateId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DeleteJobTemplateRequest.ReadOnly =
    zio.aws.iot.model.DeleteJobTemplateRequest.wrap(buildAwsValue())
}
object DeleteJobTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DeleteJobTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DeleteJobTemplateRequest =
      zio.aws.iot.model.DeleteJobTemplateRequest(jobTemplateId)
    def jobTemplateId: JobTemplateId
    def getJobTemplateId: ZIO[Any, Nothing, JobTemplateId] =
      ZIO.succeed(jobTemplateId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DeleteJobTemplateRequest
  ) extends zio.aws.iot.model.DeleteJobTemplateRequest.ReadOnly {
    override val jobTemplateId: JobTemplateId =
      zio.aws.iot.model.primitives.JobTemplateId(impl.jobTemplateId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DeleteJobTemplateRequest
  ): zio.aws.iot.model.DeleteJobTemplateRequest.ReadOnly = new Wrapper(impl)
}
