package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.PolicyName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeletePolicyRequest(policyName: PolicyName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DeletePolicyRequest = {
    import DeletePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DeletePolicyRequest
      .builder()
      .policyName(PolicyName.unwrap(policyName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DeletePolicyRequest.ReadOnly =
    zio.aws.iot.model.DeletePolicyRequest.wrap(buildAwsValue())
}
object DeletePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DeletePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DeletePolicyRequest =
      zio.aws.iot.model.DeletePolicyRequest(policyName)
    def policyName: PolicyName
    def getPolicyName: ZIO[Any, Nothing, PolicyName] = ZIO.succeed(policyName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DeletePolicyRequest
  ) extends zio.aws.iot.model.DeletePolicyRequest.ReadOnly {
    override val policyName: PolicyName =
      zio.aws.iot.model.primitives.PolicyName(impl.policyName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DeletePolicyRequest
  ): zio.aws.iot.model.DeletePolicyRequest.ReadOnly = new Wrapper(impl)
}
