package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{PolicyVersionId, PolicyName}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeletePolicyVersionRequest(
    policyName: PolicyName,
    policyVersionId: PolicyVersionId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DeletePolicyVersionRequest = {
    import DeletePolicyVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DeletePolicyVersionRequest
      .builder()
      .policyName(PolicyName.unwrap(policyName): java.lang.String)
      .policyVersionId(
        PolicyVersionId.unwrap(policyVersionId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DeletePolicyVersionRequest.ReadOnly =
    zio.aws.iot.model.DeletePolicyVersionRequest.wrap(buildAwsValue())
}
object DeletePolicyVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DeletePolicyVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DeletePolicyVersionRequest =
      zio.aws.iot.model.DeletePolicyVersionRequest(policyName, policyVersionId)
    def policyName: PolicyName
    def policyVersionId: PolicyVersionId
    def getPolicyName: ZIO[Any, Nothing, PolicyName] = ZIO.succeed(policyName)
    def getPolicyVersionId: ZIO[Any, Nothing, PolicyVersionId] =
      ZIO.succeed(policyVersionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DeletePolicyVersionRequest
  ) extends zio.aws.iot.model.DeletePolicyVersionRequest.ReadOnly {
    override val policyName: PolicyName =
      zio.aws.iot.model.primitives.PolicyName(impl.policyName())
    override val policyVersionId: PolicyVersionId =
      zio.aws.iot.model.primitives.PolicyVersionId(impl.policyVersionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DeletePolicyVersionRequest
  ): zio.aws.iot.model.DeletePolicyVersionRequest.ReadOnly = new Wrapper(impl)
}
