package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.TemplateName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteProvisioningTemplateRequest(templateName: TemplateName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DeleteProvisioningTemplateRequest = {
    import DeleteProvisioningTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DeleteProvisioningTemplateRequest
      .builder()
      .templateName(TemplateName.unwrap(templateName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DeleteProvisioningTemplateRequest.ReadOnly =
    zio.aws.iot.model.DeleteProvisioningTemplateRequest.wrap(buildAwsValue())
}
object DeleteProvisioningTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DeleteProvisioningTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DeleteProvisioningTemplateRequest =
      zio.aws.iot.model.DeleteProvisioningTemplateRequest(templateName)
    def templateName: TemplateName
    def getTemplateName: ZIO[Any, Nothing, TemplateName] =
      ZIO.succeed(templateName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DeleteProvisioningTemplateRequest
  ) extends zio.aws.iot.model.DeleteProvisioningTemplateRequest.ReadOnly {
    override val templateName: TemplateName =
      zio.aws.iot.model.primitives.TemplateName(impl.templateName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DeleteProvisioningTemplateRequest
  ): zio.aws.iot.model.DeleteProvisioningTemplateRequest.ReadOnly = new Wrapper(
    impl
  )
}
