package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.RoleAlias
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteRoleAliasRequest(roleAlias: RoleAlias) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DeleteRoleAliasRequest = {
    import DeleteRoleAliasRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DeleteRoleAliasRequest
      .builder()
      .roleAlias(RoleAlias.unwrap(roleAlias): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DeleteRoleAliasRequest.ReadOnly =
    zio.aws.iot.model.DeleteRoleAliasRequest.wrap(buildAwsValue())
}
object DeleteRoleAliasRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DeleteRoleAliasRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DeleteRoleAliasRequest =
      zio.aws.iot.model.DeleteRoleAliasRequest(roleAlias)
    def roleAlias: RoleAlias
    def getRoleAlias: ZIO[Any, Nothing, RoleAlias] = ZIO.succeed(roleAlias)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DeleteRoleAliasRequest
  ) extends zio.aws.iot.model.DeleteRoleAliasRequest.ReadOnly {
    override val roleAlias: RoleAlias =
      zio.aws.iot.model.primitives.RoleAlias(impl.roleAlias())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DeleteRoleAliasRequest
  ): zio.aws.iot.model.DeleteRoleAliasRequest.ReadOnly = new Wrapper(impl)
}
