package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.ThingTypeName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteThingTypeRequest(thingTypeName: ThingTypeName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DeleteThingTypeRequest = {
    import DeleteThingTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DeleteThingTypeRequest
      .builder()
      .thingTypeName(ThingTypeName.unwrap(thingTypeName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DeleteThingTypeRequest.ReadOnly =
    zio.aws.iot.model.DeleteThingTypeRequest.wrap(buildAwsValue())
}
object DeleteThingTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DeleteThingTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DeleteThingTypeRequest =
      zio.aws.iot.model.DeleteThingTypeRequest(thingTypeName)
    def thingTypeName: ThingTypeName
    def getThingTypeName: ZIO[Any, Nothing, ThingTypeName] =
      ZIO.succeed(thingTypeName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DeleteThingTypeRequest
  ) extends zio.aws.iot.model.DeleteThingTypeRequest.ReadOnly {
    override val thingTypeName: ThingTypeName =
      zio.aws.iot.model.primitives.ThingTypeName(impl.thingTypeName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DeleteThingTypeRequest
  ): zio.aws.iot.model.DeleteThingTypeRequest.ReadOnly = new Wrapper(impl)
}
