package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.LogTargetName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteV2LoggingLevelRequest(
    targetType: zio.aws.iot.model.LogTargetType,
    targetName: LogTargetName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DeleteV2LoggingLevelRequest = {
    import DeleteV2LoggingLevelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DeleteV2LoggingLevelRequest
      .builder()
      .targetType(targetType.unwrap)
      .targetName(LogTargetName.unwrap(targetName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DeleteV2LoggingLevelRequest.ReadOnly =
    zio.aws.iot.model.DeleteV2LoggingLevelRequest.wrap(buildAwsValue())
}
object DeleteV2LoggingLevelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DeleteV2LoggingLevelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DeleteV2LoggingLevelRequest =
      zio.aws.iot.model.DeleteV2LoggingLevelRequest(targetType, targetName)
    def targetType: zio.aws.iot.model.LogTargetType
    def targetName: LogTargetName
    def getTargetType: ZIO[Any, Nothing, zio.aws.iot.model.LogTargetType] =
      ZIO.succeed(targetType)
    def getTargetName: ZIO[Any, Nothing, LogTargetName] =
      ZIO.succeed(targetName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DeleteV2LoggingLevelRequest
  ) extends zio.aws.iot.model.DeleteV2LoggingLevelRequest.ReadOnly {
    override val targetType: zio.aws.iot.model.LogTargetType =
      zio.aws.iot.model.LogTargetType.wrap(impl.targetType())
    override val targetName: LogTargetName =
      zio.aws.iot.model.primitives.LogTargetName(impl.targetName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DeleteV2LoggingLevelRequest
  ): zio.aws.iot.model.DeleteV2LoggingLevelRequest.ReadOnly = new Wrapper(impl)
}
