package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.FindingId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeAuditFindingRequest(findingId: FindingId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeAuditFindingRequest = {
    import DescribeAuditFindingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeAuditFindingRequest
      .builder()
      .findingId(FindingId.unwrap(findingId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeAuditFindingRequest.ReadOnly =
    zio.aws.iot.model.DescribeAuditFindingRequest.wrap(buildAwsValue())
}
object DescribeAuditFindingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeAuditFindingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeAuditFindingRequest =
      zio.aws.iot.model.DescribeAuditFindingRequest(findingId)
    def findingId: FindingId
    def getFindingId: ZIO[Any, Nothing, FindingId] = ZIO.succeed(findingId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeAuditFindingRequest
  ) extends zio.aws.iot.model.DescribeAuditFindingRequest.ReadOnly {
    override val findingId: FindingId =
      zio.aws.iot.model.primitives.FindingId(impl.findingId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeAuditFindingRequest
  ): zio.aws.iot.model.DescribeAuditFindingRequest.ReadOnly = new Wrapper(impl)
}
