package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.AuditCheckName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeAuditSuppressionRequest(
    checkName: AuditCheckName,
    resourceIdentifier: zio.aws.iot.model.ResourceIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeAuditSuppressionRequest = {
    import DescribeAuditSuppressionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeAuditSuppressionRequest
      .builder()
      .checkName(AuditCheckName.unwrap(checkName): java.lang.String)
      .resourceIdentifier(resourceIdentifier.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeAuditSuppressionRequest.ReadOnly =
    zio.aws.iot.model.DescribeAuditSuppressionRequest.wrap(buildAwsValue())
}
object DescribeAuditSuppressionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeAuditSuppressionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeAuditSuppressionRequest =
      zio.aws.iot.model.DescribeAuditSuppressionRequest(
        checkName,
        resourceIdentifier.asEditable
      )
    def checkName: AuditCheckName
    def resourceIdentifier: zio.aws.iot.model.ResourceIdentifier.ReadOnly
    def getCheckName: ZIO[Any, Nothing, AuditCheckName] = ZIO.succeed(checkName)
    def getResourceIdentifier
        : ZIO[Any, Nothing, zio.aws.iot.model.ResourceIdentifier.ReadOnly] =
      ZIO.succeed(resourceIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeAuditSuppressionRequest
  ) extends zio.aws.iot.model.DescribeAuditSuppressionRequest.ReadOnly {
    override val checkName: AuditCheckName =
      zio.aws.iot.model.primitives.AuditCheckName(impl.checkName())
    override val resourceIdentifier
        : zio.aws.iot.model.ResourceIdentifier.ReadOnly =
      zio.aws.iot.model.ResourceIdentifier.wrap(impl.resourceIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeAuditSuppressionRequest
  ): zio.aws.iot.model.DescribeAuditSuppressionRequest.ReadOnly = new Wrapper(
    impl
  )
}
