package zio.aws.iot.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  AuditDescription,
  SuppressIndefinitely,
  Timestamp,
  AuditCheckName
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeAuditSuppressionResponse(
    checkName: Optional[AuditCheckName] = Optional.Absent,
    resourceIdentifier: Optional[zio.aws.iot.model.ResourceIdentifier] =
      Optional.Absent,
    expirationDate: Optional[Timestamp] = Optional.Absent,
    suppressIndefinitely: Optional[SuppressIndefinitely] = Optional.Absent,
    description: Optional[AuditDescription] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeAuditSuppressionResponse = {
    import DescribeAuditSuppressionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeAuditSuppressionResponse
      .builder()
      .optionallyWith(
        checkName.map(value => AuditCheckName.unwrap(value): java.lang.String)
      )(_.checkName)
      .optionallyWith(resourceIdentifier.map(value => value.buildAwsValue()))(
        _.resourceIdentifier
      )
      .optionallyWith(
        expirationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.expirationDate)
      .optionallyWith(
        suppressIndefinitely.map(value =>
          SuppressIndefinitely.unwrap(value): java.lang.Boolean
        )
      )(_.suppressIndefinitely)
      .optionallyWith(
        description.map(value =>
          AuditDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeAuditSuppressionResponse.ReadOnly =
    zio.aws.iot.model.DescribeAuditSuppressionResponse.wrap(buildAwsValue())
}
object DescribeAuditSuppressionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeAuditSuppressionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeAuditSuppressionResponse =
      zio.aws.iot.model.DescribeAuditSuppressionResponse(
        checkName.map(value => value),
        resourceIdentifier.map(value => value.asEditable),
        expirationDate.map(value => value),
        suppressIndefinitely.map(value => value),
        description.map(value => value)
      )
    def checkName: Optional[AuditCheckName]
    def resourceIdentifier
        : Optional[zio.aws.iot.model.ResourceIdentifier.ReadOnly]
    def expirationDate: Optional[Timestamp]
    def suppressIndefinitely: Optional[SuppressIndefinitely]
    def description: Optional[AuditDescription]
    def getCheckName: ZIO[Any, AwsError, AuditCheckName] =
      AwsError.unwrapOptionField("checkName", checkName)
    def getResourceIdentifier
        : ZIO[Any, AwsError, zio.aws.iot.model.ResourceIdentifier.ReadOnly] =
      AwsError.unwrapOptionField("resourceIdentifier", resourceIdentifier)
    def getExpirationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("expirationDate", expirationDate)
    def getSuppressIndefinitely: ZIO[Any, AwsError, SuppressIndefinitely] =
      AwsError.unwrapOptionField("suppressIndefinitely", suppressIndefinitely)
    def getDescription: ZIO[Any, AwsError, AuditDescription] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeAuditSuppressionResponse
  ) extends zio.aws.iot.model.DescribeAuditSuppressionResponse.ReadOnly {
    override val checkName: Optional[AuditCheckName] = zio.aws.core.internal
      .optionalFromNullable(impl.checkName())
      .map(value => zio.aws.iot.model.primitives.AuditCheckName(value))
    override val resourceIdentifier
        : Optional[zio.aws.iot.model.ResourceIdentifier.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceIdentifier())
        .map(value => zio.aws.iot.model.ResourceIdentifier.wrap(value))
    override val expirationDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.expirationDate())
      .map(value => zio.aws.iot.model.primitives.Timestamp(value))
    override val suppressIndefinitely: Optional[SuppressIndefinitely] =
      zio.aws.core.internal
        .optionalFromNullable(impl.suppressIndefinitely())
        .map(value => zio.aws.iot.model.primitives.SuppressIndefinitely(value))
    override val description: Optional[AuditDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iot.model.primitives.AuditDescription(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeAuditSuppressionResponse
  ): zio.aws.iot.model.DescribeAuditSuppressionResponse.ReadOnly = new Wrapper(
    impl
  )
}
