package zio.aws.iot.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  AuditCheckName,
  ScheduledAuditName,
  Timestamp
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeAuditTaskResponse(
    taskStatus: Optional[zio.aws.iot.model.AuditTaskStatus] = Optional.Absent,
    taskType: Optional[zio.aws.iot.model.AuditTaskType] = Optional.Absent,
    taskStartTime: Optional[Timestamp] = Optional.Absent,
    taskStatistics: Optional[zio.aws.iot.model.TaskStatistics] =
      Optional.Absent,
    scheduledAuditName: Optional[ScheduledAuditName] = Optional.Absent,
    auditDetails: Optional[
      Map[AuditCheckName, zio.aws.iot.model.AuditCheckDetails]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeAuditTaskResponse = {
    import DescribeAuditTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeAuditTaskResponse
      .builder()
      .optionallyWith(taskStatus.map(value => value.unwrap))(_.taskStatus)
      .optionallyWith(taskType.map(value => value.unwrap))(_.taskType)
      .optionallyWith(
        taskStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.taskStartTime)
      .optionallyWith(taskStatistics.map(value => value.buildAwsValue()))(
        _.taskStatistics
      )
      .optionallyWith(
        scheduledAuditName.map(value =>
          ScheduledAuditName.unwrap(value): java.lang.String
        )
      )(_.scheduledAuditName)
      .optionallyWith(
        auditDetails.map(value =>
          value
            .map({ case (key, value) =>
              (AuditCheckName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.auditDetails)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeAuditTaskResponse.ReadOnly =
    zio.aws.iot.model.DescribeAuditTaskResponse.wrap(buildAwsValue())
}
object DescribeAuditTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeAuditTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeAuditTaskResponse =
      zio.aws.iot.model.DescribeAuditTaskResponse(
        taskStatus.map(value => value),
        taskType.map(value => value),
        taskStartTime.map(value => value),
        taskStatistics.map(value => value.asEditable),
        scheduledAuditName.map(value => value),
        auditDetails.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def taskStatus: Optional[zio.aws.iot.model.AuditTaskStatus]
    def taskType: Optional[zio.aws.iot.model.AuditTaskType]
    def taskStartTime: Optional[Timestamp]
    def taskStatistics: Optional[zio.aws.iot.model.TaskStatistics.ReadOnly]
    def scheduledAuditName: Optional[ScheduledAuditName]
    def auditDetails: Optional[
      Map[AuditCheckName, zio.aws.iot.model.AuditCheckDetails.ReadOnly]
    ]
    def getTaskStatus: ZIO[Any, AwsError, zio.aws.iot.model.AuditTaskStatus] =
      AwsError.unwrapOptionField("taskStatus", taskStatus)
    def getTaskType: ZIO[Any, AwsError, zio.aws.iot.model.AuditTaskType] =
      AwsError.unwrapOptionField("taskType", taskType)
    def getTaskStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("taskStartTime", taskStartTime)
    def getTaskStatistics
        : ZIO[Any, AwsError, zio.aws.iot.model.TaskStatistics.ReadOnly] =
      AwsError.unwrapOptionField("taskStatistics", taskStatistics)
    def getScheduledAuditName: ZIO[Any, AwsError, ScheduledAuditName] =
      AwsError.unwrapOptionField("scheduledAuditName", scheduledAuditName)
    def getAuditDetails: ZIO[Any, AwsError, Map[
      AuditCheckName,
      zio.aws.iot.model.AuditCheckDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("auditDetails", auditDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeAuditTaskResponse
  ) extends zio.aws.iot.model.DescribeAuditTaskResponse.ReadOnly {
    override val taskStatus: Optional[zio.aws.iot.model.AuditTaskStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskStatus())
        .map(value => zio.aws.iot.model.AuditTaskStatus.wrap(value))
    override val taskType: Optional[zio.aws.iot.model.AuditTaskType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskType())
        .map(value => zio.aws.iot.model.AuditTaskType.wrap(value))
    override val taskStartTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.taskStartTime())
      .map(value => zio.aws.iot.model.primitives.Timestamp(value))
    override val taskStatistics
        : Optional[zio.aws.iot.model.TaskStatistics.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskStatistics())
        .map(value => zio.aws.iot.model.TaskStatistics.wrap(value))
    override val scheduledAuditName: Optional[ScheduledAuditName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scheduledAuditName())
        .map(value => zio.aws.iot.model.primitives.ScheduledAuditName(value))
    override val auditDetails: Optional[
      Map[AuditCheckName, zio.aws.iot.model.AuditCheckDetails.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.auditDetails())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iot.model.primitives.AuditCheckName(
              key
            ) -> zio.aws.iot.model.AuditCheckDetails.wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeAuditTaskResponse
  ): zio.aws.iot.model.DescribeAuditTaskResponse.ReadOnly = new Wrapper(impl)
}
