package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.AuthorizerName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeAuthorizerRequest(authorizerName: AuthorizerName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeAuthorizerRequest = {
    import DescribeAuthorizerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeAuthorizerRequest
      .builder()
      .authorizerName(AuthorizerName.unwrap(authorizerName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeAuthorizerRequest.ReadOnly =
    zio.aws.iot.model.DescribeAuthorizerRequest.wrap(buildAwsValue())
}
object DescribeAuthorizerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeAuthorizerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeAuthorizerRequest =
      zio.aws.iot.model.DescribeAuthorizerRequest(authorizerName)
    def authorizerName: AuthorizerName
    def getAuthorizerName: ZIO[Any, Nothing, AuthorizerName] =
      ZIO.succeed(authorizerName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeAuthorizerRequest
  ) extends zio.aws.iot.model.DescribeAuthorizerRequest.ReadOnly {
    override val authorizerName: AuthorizerName =
      zio.aws.iot.model.primitives.AuthorizerName(impl.authorizerName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeAuthorizerRequest
  ): zio.aws.iot.model.DescribeAuthorizerRequest.ReadOnly = new Wrapper(impl)
}
