package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  Version,
  BillingGroupArn,
  BillingGroupId,
  BillingGroupName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeBillingGroupResponse(
    billingGroupName: Optional[BillingGroupName] = Optional.Absent,
    billingGroupId: Optional[BillingGroupId] = Optional.Absent,
    billingGroupArn: Optional[BillingGroupArn] = Optional.Absent,
    version: Optional[Version] = Optional.Absent,
    billingGroupProperties: Optional[zio.aws.iot.model.BillingGroupProperties] =
      Optional.Absent,
    billingGroupMetadata: Optional[zio.aws.iot.model.BillingGroupMetadata] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeBillingGroupResponse = {
    import DescribeBillingGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeBillingGroupResponse
      .builder()
      .optionallyWith(
        billingGroupName.map(value =>
          BillingGroupName.unwrap(value): java.lang.String
        )
      )(_.billingGroupName)
      .optionallyWith(
        billingGroupId.map(value =>
          BillingGroupId.unwrap(value): java.lang.String
        )
      )(_.billingGroupId)
      .optionallyWith(
        billingGroupArn.map(value =>
          BillingGroupArn.unwrap(value): java.lang.String
        )
      )(_.billingGroupArn)
      .optionallyWith(
        version.map(value => Version.unwrap(value): java.lang.Long)
      )(_.version)
      .optionallyWith(
        billingGroupProperties.map(value => value.buildAwsValue())
      )(_.billingGroupProperties)
      .optionallyWith(billingGroupMetadata.map(value => value.buildAwsValue()))(
        _.billingGroupMetadata
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeBillingGroupResponse.ReadOnly =
    zio.aws.iot.model.DescribeBillingGroupResponse.wrap(buildAwsValue())
}
object DescribeBillingGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeBillingGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeBillingGroupResponse =
      zio.aws.iot.model.DescribeBillingGroupResponse(
        billingGroupName.map(value => value),
        billingGroupId.map(value => value),
        billingGroupArn.map(value => value),
        version.map(value => value),
        billingGroupProperties.map(value => value.asEditable),
        billingGroupMetadata.map(value => value.asEditable)
      )
    def billingGroupName: Optional[BillingGroupName]
    def billingGroupId: Optional[BillingGroupId]
    def billingGroupArn: Optional[BillingGroupArn]
    def version: Optional[Version]
    def billingGroupProperties
        : Optional[zio.aws.iot.model.BillingGroupProperties.ReadOnly]
    def billingGroupMetadata
        : Optional[zio.aws.iot.model.BillingGroupMetadata.ReadOnly]
    def getBillingGroupName: ZIO[Any, AwsError, BillingGroupName] =
      AwsError.unwrapOptionField("billingGroupName", billingGroupName)
    def getBillingGroupId: ZIO[Any, AwsError, BillingGroupId] =
      AwsError.unwrapOptionField("billingGroupId", billingGroupId)
    def getBillingGroupArn: ZIO[Any, AwsError, BillingGroupArn] =
      AwsError.unwrapOptionField("billingGroupArn", billingGroupArn)
    def getVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("version", version)
    def getBillingGroupProperties: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.BillingGroupProperties.ReadOnly
    ] = AwsError.unwrapOptionField(
      "billingGroupProperties",
      billingGroupProperties
    )
    def getBillingGroupMetadata
        : ZIO[Any, AwsError, zio.aws.iot.model.BillingGroupMetadata.ReadOnly] =
      AwsError.unwrapOptionField("billingGroupMetadata", billingGroupMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeBillingGroupResponse
  ) extends zio.aws.iot.model.DescribeBillingGroupResponse.ReadOnly {
    override val billingGroupName: Optional[BillingGroupName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.billingGroupName())
        .map(value => zio.aws.iot.model.primitives.BillingGroupName(value))
    override val billingGroupId: Optional[BillingGroupId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.billingGroupId())
        .map(value => zio.aws.iot.model.primitives.BillingGroupId(value))
    override val billingGroupArn: Optional[BillingGroupArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.billingGroupArn())
        .map(value => zio.aws.iot.model.primitives.BillingGroupArn(value))
    override val version: Optional[Version] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.iot.model.primitives.Version(value))
    override val billingGroupProperties
        : Optional[zio.aws.iot.model.BillingGroupProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.billingGroupProperties())
        .map(value => zio.aws.iot.model.BillingGroupProperties.wrap(value))
    override val billingGroupMetadata
        : Optional[zio.aws.iot.model.BillingGroupMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.billingGroupMetadata())
        .map(value => zio.aws.iot.model.BillingGroupMetadata.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeBillingGroupResponse
  ): zio.aws.iot.model.DescribeBillingGroupResponse.ReadOnly = new Wrapper(impl)
}
